/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.container;

import dev.xylonity.companions.common.entity.companion.SoulMageEntity;
import dev.xylonity.companions.common.item.book.AbstractMagicBook;
import dev.xylonity.companions.registry.CompanionsMenuTypes;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SoulMageContainerMenu
extends AbstractContainerMenu {
    private final SoulMageEntity soulMage;
    private final Container entityInventory;

    public SoulMageContainerMenu(int windowId, Inventory playerInv, SoulMageEntity mage) {
        super(CompanionsMenuTypes.SOUL_MAGE_CONTAINER.get(), windowId);
        int col;
        this.soulMage = mage;
        this.entityInventory = mage.inventory;
        SoulMageContainerMenu.checkContainerSize((Container)this.entityInventory, (int)3);
        this.entityInventory.startOpen(playerInv.player);
        this.addSlot(new BookSlot(this.entityInventory, 0, 57, 32));
        this.addSlot(new BookSlot(this.entityInventory, 1, 111, 32));
        this.addSlot(new BookSlot(this.entityInventory, 2, 165, 32));
        int PLAYER_INVENTORY_START_Y = 92;
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInv, col + row * 9 + 9, 39 + col * 18, 92 + row * 18));
            }
        }
        int HOTBAR_START_Y = 150;
        for (col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInv, col, 39 + col * 18, 150));
        }
    }

    public boolean stillValid(@NotNull Player player) {
        return this.entityInventory.stillValid(player) && this.soulMage.isAlive() && this.soulMage.distanceTo((Entity)player) < 8.0f;
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        this.entityInventory.stopOpen(player);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stackInSlot = slot.getItem();
            itemstack = stackInSlot.copy();
            int containerSize = this.entityInventory.getContainerSize();
            if (index < containerSize ? !this.moveItemStackTo(stackInSlot, containerSize, this.slots.size(), true) : !this.moveItemStackTo(stackInSlot, 0, containerSize, false)) {
                return ItemStack.EMPTY;
            }
            if (stackInSlot.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public static class BookSlot
    extends Slot {
        public BookSlot(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }

        public boolean mayPlace(@NotNull ItemStack stack) {
            return stack.getItem() instanceof AbstractMagicBook;
        }
    }
}

