/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity;

import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.knightlib.registry.KnightLibItems;
import dev.xylonity.knightlib.registry.KnightLibParticles;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class CompanionEntity
extends TamableAnimal
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> MAIN_ACTION = SynchedEntityData.defineId(CompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SIT_VARIATION = SynchedEntityData.defineId(CompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> NO_MOVEMENT = SynchedEntityData.defineId(CompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private ChunkPos lastChunkPos;

    protected CompanionEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.noCulling = true;
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    public void tick() {
        Level level;
        super.tick();
        if (this.isNoMovement()) {
            this.getNavigation().stop();
            this.setDeltaMovement(Vec3.ZERO);
        }
        if (this.shouldKeepChunkLoaded() && (level = this.level()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ChunkPos currentChunkPos = new ChunkPos(this.blockPosition());
            if (!currentChunkPos.equals((Object)this.lastChunkPos)) {
                if (this.lastChunkPos != null) {
                    level2.setChunkForced(this.lastChunkPos.x, this.lastChunkPos.z, false);
                }
                level2.setChunkForced(currentChunkPos.x, currentChunkPos.z, true);
                this.lastChunkPos = currentChunkPos;
            }
        }
    }

    public void checkDespawn() {
        if (this.isTame() && this.shouldKeepChunkLoaded()) {
            return;
        }
        super.checkDespawn();
    }

    public boolean isPersistenceRequired() {
        return this.isTame() && this.shouldKeepChunkLoaded();
    }

    public boolean requiresCustomPersistence() {
        return this.isTame() && this.shouldKeepChunkLoaded();
    }

    public void remove(@NotNull Entity.RemovalReason pReason) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (this.lastChunkPos != null) {
                level2.setChunkForced(this.lastChunkPos.x, this.lastChunkPos.z, false);
            }
        }
        super.remove(pReason);
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (pSource.getEntity() != null && pSource.getEntity().equals((Object)this.getOwner()) & !pSource.getEntity().isShiftKeyDown()) {
            return false;
        }
        return super.hurt(pSource, pAmount);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MAIN_ACTION, (Object)1);
        builder.define(NO_MOVEMENT, (Object)false);
        builder.define(SIT_VARIATION, (Object)0);
    }

    public void setMainAction(int action, @Nullable Player player) {
        ArrayList<Integer> allowedActions = new ArrayList<Integer>();
        allowedActions.add(0);
        allowedActions.add(1);
        if (CompanionsConfig.SHOULD_COMPANIONS_WANDER) {
            allowedActions.add(2);
        }
        int newAction = (Integer)allowedActions.get(action % allowedActions.size());
        this.entityData.set(MAIN_ACTION, (Object)newAction);
        if (player != null) {
            switch (newAction) {
                case 0: {
                    player.displayClientMessage((Component)Component.translatable((String)"main_action.companions.client_message.is_sitting", (Object[])new Object[]{this.getName()}), true);
                    break;
                }
                case 1: {
                    player.displayClientMessage((Component)Component.translatable((String)"main_action.companions.client_message.is_following", (Object[])new Object[]{this.getName()}), true);
                    break;
                }
                case 2: {
                    player.displayClientMessage((Component)Component.translatable((String)"main_action.companions.client_message.is_wandering", (Object[])new Object[]{this.getName()}), true);
                    break;
                }
                default: {
                    player.displayClientMessage((Component)Component.translatable((String)"main_action.companions.client_message.is_working", (Object[])new Object[]{this.getName()}), true);
                }
            }
        }
    }

    public int getMainAction() {
        return (Integer)this.entityData.get(MAIN_ACTION);
    }

    public boolean isNoMovement() {
        return (Boolean)this.entityData.get(NO_MOVEMENT);
    }

    public void setNoMovement(boolean isNoMovement) {
        this.entityData.set(NO_MOVEMENT, (Object)isNoMovement);
    }

    public int getSitVariation() {
        return (Integer)this.entityData.get(SIT_VARIATION);
    }

    public void setSitVariation(int variation) {
        this.entityData.set(SIT_VARIATION, (Object)variation);
    }

    @Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel serverLevel, @NotNull AgeableMob ageableMob) {
        return null;
    }

    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("CompanionsMainAction")) {
            this.setMainAction(pCompound.getInt("CompanionsMainAction"), null);
        }
        if (pCompound.contains("CompanionsSitVariation")) {
            this.setSitVariation(pCompound.getInt("CompanionsSitVariation"));
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("CompanionsMainAction", this.getMainAction());
        pCompound.putInt("CompanionsSitVariation", this.getSitVariation());
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void defaultMainActionInteraction(Player pPlayer) {
        this.setMainAction(this.getMainAction() + 1, pPlayer);
        if (this.getMainAction() == 0) {
            this.setSitVariation(new Random().nextInt(0, this.sitAnimationsAmount()));
            this.setTarget(null);
            this.setOrderedToSit(true);
        } else {
            this.setOrderedToSit(false);
        }
    }

    public boolean handleDefaultMainActionAndHeal(Player pPlayer, InteractionHand hand) {
        if (this.level().isClientSide) {
            return true;
        }
        ItemStack stack = pPlayer.getItemInHand(hand);
        Item item = stack.getItem();
        if (this.isTame() && pPlayer == this.getOwner()) {
            if (item == KnightLibItems.SMALL_ESSENCE.get() && this.getHealth() != this.getMaxHealth()) {
                if (!pPlayer.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                this.heal(this.getHealth() * 0.05f);
                this.summonHealParticles();
            } else if (item == KnightLibItems.GREAT_ESSENCE.get() && this.getHealth() != this.getMaxHealth()) {
                if (!pPlayer.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                this.heal(this.getHealth() * 0.2f);
                this.summonHealParticles();
            } else {
                this.defaultMainActionInteraction(pPlayer);
            }
            return true;
        }
        return false;
    }

    public void tameInteraction(Player pPlayer) {
        super.tame(pPlayer);
        this.navigation.recomputePath();
        this.setTarget(null);
        this.level().broadcastEntityEvent((Entity)this, (byte)7);
        this.setMainAction(0, pPlayer);
        this.setSitVariation(new Random().nextInt(0, this.sitAnimationsAmount()));
        this.setOrderedToSit(true);
    }

    private void summonHealParticles() {
        for (int i = 0; i < 10; ++i) {
            double dx = (this.random.nextDouble() - 0.5) * 1.25;
            double dy = (this.random.nextDouble() - 0.5) * 1.25;
            double dz = (this.random.nextDouble() - 0.5) * 1.25;
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            if (level2.random.nextFloat() < 0.45f) {
                level2.sendParticles((ParticleOptions)ParticleTypes.POOF, this.getX(), this.getY() + 0.15, this.getZ(), 1, dx, dy, dz, 0.1);
            }
            if (!(level2.random.nextFloat() < 0.25f)) continue;
            level2.sendParticles((ParticleOptions)((SimpleParticleType)KnightLibParticles.STARSET.get()), this.getX(), this.getY() + 0.15, this.getZ(), 1, dx, dy, dz, 0.1);
        }
    }

    protected abstract boolean canThisCompanionWork();

    protected abstract int sitAnimationsAmount();

    protected abstract boolean shouldKeepChunkLoaded();

    public boolean canChangeDimensions(Level oldLevel, Level newLevel) {
        return true;
    }
}

