/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity;

import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.companion.CorneliusEntity;
import dev.xylonity.companions.common.util.Util;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class CompanionSummonEntity
extends TamableAnimal
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> MAIN_ACTION = SynchedEntityData.defineId(CompanionSummonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> NO_MOVEMENT = SynchedEntityData.defineId(CompanionSummonEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.defineId(CompanionSummonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<UUID>> SECOND_OWNER_UUID = SynchedEntityData.defineId(CompanionSummonEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);

    protected CompanionSummonEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.noCulling = true;
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    public void tick() {
        super.tick();
        if (this.isNoMovement()) {
            this.getNavigation().stop();
            this.setDeltaMovement(0.0, this.getDeltaMovement().y(), 0.0);
        }
        if (this.tickCount % 20 == 0) {
            this.checkOwnersStatus();
        }
    }

    private void checkOwnersStatus() {
        if (!this.level().isClientSide) {
            LivingEntity owner1 = this.getOwner();
            LivingEntity owner2 = this.getSecondOwner();
            if ((owner1 == null || !owner1.isAlive() && !(owner1 instanceof Player)) && owner2 != null && owner2.isAlive()) {
                this.promoteSecondOwnerToPrimary();
            }
            if (!(owner2 != null && owner2.isAlive() || this.getSecondOwnerUUID() == null || this.getOwner() instanceof CompanionEntity)) {
                this.setSecondOwnerUUID(null);
            }
        }
    }

    private void promoteSecondOwnerToPrimary() {
        UUID cache = this.getSecondOwnerUUID();
        if (cache != null) {
            this.setOwnerUUID(cache);
            this.setSecondOwnerUUID(null);
            this.entityData.set(MAIN_ACTION, (Object)0);
            this.setTame(true, false);
        }
    }

    public UUID getSecondOwnerUUID() {
        return ((Optional)this.entityData.get(SECOND_OWNER_UUID)).orElse(null);
    }

    public void setSecondOwnerUUID(@Nullable UUID pUuid) {
        this.entityData.set(SECOND_OWNER_UUID, Optional.ofNullable(pUuid));
    }

    public void die(@NotNull DamageSource pCause) {
        CorneliusEntity e;
        LivingEntity livingEntity;
        super.die(pCause);
        if (this.getOwner() != null && (livingEntity = this.getOwner()) instanceof CorneliusEntity && (e = (CorneliusEntity)livingEntity).getSummonedCount() > 0) {
            e.setSummonedCount(e.getSummonedCount() - 1);
        }
    }

    public int getAttackType() {
        return (Integer)this.entityData.get(ATTACK_TYPE);
    }

    public void setAttackType(int type) {
        this.entityData.set(ATTACK_TYPE, (Object)type);
    }

    public void cycleMainAction(@Nullable Player player) {
        if (!this.canCycleOwners()) {
            return;
        }
        this.entityData.set(MAIN_ACTION, (Object)((this.getMainAction() + 1) % 2));
        if (player != null) {
            this.cycleOwners();
            if (this.getOwner() instanceof Player) {
                player.displayClientMessage((Component)Component.translatable((String)"main_action_summon.companions.client_message.following_player", (Object[])new Object[]{this.getName()}), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"main_action_summon.companions.client_message.following_companion", (Object[])new Object[]{this.getName(), this.getOwner() != null ? this.getOwner().getName() : "the companion."}), true);
            }
        }
    }

    private boolean canCycleOwners() {
        LivingEntity owner = this.getOwner();
        LivingEntity owner2 = this.getSecondOwner();
        if (owner == null && owner2 != null && owner2.isAlive()) {
            return true;
        }
        return owner != null && owner.isAlive() && owner2 != null && owner2.isAlive();
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (pHand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (Util.areEntitiesLinked((Entity)pPlayer, (Entity)this)) {
            if (this.level().isClientSide) {
                if (this.getSecondOwner() == null) {
                    return InteractionResult.PASS;
                }
                return InteractionResult.SUCCESS;
            }
            this.cycleMainAction(pPlayer);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(pPlayer, pHand);
    }

    private void cycleOwners() {
        UUID cache = this.getOwnerUUID();
        this.setOwnerUUID(this.getSecondOwnerUUID());
        this.setSecondOwnerUUID(cache);
        this.setTame(true, false);
    }

    public int getMainAction() {
        return (Integer)this.entityData.get(MAIN_ACTION);
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (pSource.getEntity() != null && pSource.getEntity().equals((Object)this.getOwner()) & !pSource.getEntity().isShiftKeyDown()) {
            return false;
        }
        return super.hurt(pSource, pAmount);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("SecondaryOwnerUUID")) {
            this.setSecondOwnerUUID(pCompound.getUUID("SecondaryOwnerUUID"));
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        if (this.getSecondOwnerUUID() != null) {
            pCompound.putUUID("SecondaryOwnerUUID", this.getSecondOwnerUUID());
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        UUID ownerUUID = this.getOwnerUUID();
        if (ownerUUID == null) {
            return null;
        }
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Entity owner = serverLevel.getEntity(ownerUUID);
        return owner instanceof LivingEntity ? (LivingEntity)owner : null;
    }

    @Nullable
    public LivingEntity getSecondOwner() {
        UUID secondOwnerUUID = this.getSecondOwnerUUID();
        if (secondOwnerUUID == null) {
            return null;
        }
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Entity owner = serverLevel.getEntity(secondOwnerUUID);
        return owner instanceof LivingEntity ? (LivingEntity)owner : null;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ATTACK_TYPE, (Object)0);
        builder.define(MAIN_ACTION, (Object)0);
        builder.define(NO_MOVEMENT, (Object)false);
        builder.define(SECOND_OWNER_UUID, Optional.empty());
    }

    public boolean isNoMovement() {
        return (Boolean)this.entityData.get(NO_MOVEMENT);
    }

    public void setNoMovement(boolean isNoMovement) {
        this.entityData.set(NO_MOVEMENT, (Object)isNoMovement);
    }

    @Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel serverLevel, @NotNull AgeableMob ageableMob) {
        return null;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

