/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.antlion.tamable;

import dev.xylonity.companions.common.entity.companion.AntlionEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public abstract class AbstractAntlionAttackGoal
extends Goal {
    protected final AntlionEntity antlion;
    protected final int attackDuration;
    protected final int minCooldown;
    protected final int maxCooldown;
    protected int attackTicks;
    protected int nextUseTick;
    protected boolean started;

    public AbstractAntlionAttackGoal(AntlionEntity antlion, int attackDuration, int minCd, int maxCd) {
        this.antlion = antlion;
        this.attackDuration = attackDuration;
        this.minCooldown = minCd;
        this.maxCooldown = maxCd;
        this.nextUseTick = -1;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.antlion.getAttackType() != 0) {
            return false;
        }
        if (this.antlion.getVariant() != this.variant()) {
            return false;
        }
        if (this.antlion.getTarget() == null) {
            return false;
        }
        if (this.antlion.getMainAction() != 1) {
            return false;
        }
        if (this.nextUseTick < 0) {
            this.nextUseTick = this.antlion.tickCount + this.minCooldown + this.antlion.getRandom().nextInt(this.maxCooldown - this.minCooldown + 1);
            return false;
        }
        return this.antlion.tickCount >= this.nextUseTick;
    }

    public boolean canContinueToUse() {
        return this.started && this.attackTicks < this.attackDuration;
    }

    public void start() {
        this.attackTicks = 0;
        this.started = true;
        this.antlion.setAttackType(this.attackType());
    }

    public void stop() {
        this.started = false;
        this.antlion.setAttackType(0);
        int cd = this.minCooldown + this.antlion.getRandom().nextInt(this.maxCooldown - this.minCooldown + 1);
        this.nextUseTick = this.antlion.tickCount + cd;
    }

    public void tick() {
        LivingEntity target = this.antlion.getTarget();
        if (target != null) {
            this.antlion.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            this.antlion.lookAt((Entity)target, 30.0f, 30.0f);
        }
        if (this.attackTicks == this.attackDelay() && target != null && target.isAlive()) {
            this.performAttack(target);
        }
        ++this.attackTicks;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    protected abstract void performAttack(LivingEntity var1);

    protected abstract int attackDelay();

    protected abstract int attackType();

    protected abstract int variant();
}

