/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.cornelius.summon.goal;

import dev.xylonity.companions.common.entity.CompanionSummonEntity;
import dev.xylonity.companions.common.entity.ai.cornelius.summon.AbstractCorneliusSummonAttackGoal;
import dev.xylonity.companions.common.entity.summon.NetherBullfrogEntity;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class NetherBullfrogAirSlashGoal
extends AbstractCorneliusSummonAttackGoal {
    public NetherBullfrogAirSlashGoal(CompanionSummonEntity summon, int minCd, int maxCd) {
        super(summon, 55, minCd, maxCd);
    }

    @Override
    public void start() {
        super.start();
        this.summon.setNoMovement(true);
        LivingEntity target = this.summon.getTarget();
        if (target != null) {
            this.summon.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.summon.setNoMovement(false);
    }

    @Override
    public boolean canUse() {
        return super.canUse() && this.summon.getTarget() != null && this.summon.distanceTo((Entity)this.summon.getTarget()) < 3.0f;
    }

    @Override
    public void tick() {
        LivingEntity target = this.summon.getTarget();
        if (this.attackTicks == this.attackDelay() && target != null && target.isAlive()) {
            this.performAttack(target);
        }
        if (this.attackTicks == this.attackDelay()) {
            this.spawnParticles();
        }
        ++this.attackTicks;
    }

    @Override
    protected int getAttackType() {
        return 4;
    }

    @Override
    protected void performAttack(LivingEntity target) {
        for (LivingEntity e : this.summon.level().getEntitiesOfClass(LivingEntity.class, this.summon.getBoundingBox().inflate(2.5))) {
            if (Util.areEntitiesLinked((Entity)e, (Entity)this.summon)) continue;
            e.hurt(this.summon.damageSources().mobAttack((LivingEntity)this.summon), 9.0f);
        }
        this.summon.playSound(CompanionsSounds.NETHER_BULLFROG_AIR_SLASH_END.get());
    }

    protected void spawnParticles() {
        Level level = this.summon.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        Vec3 look = this.summon.getLookAngle();
        double bx = this.summon.getX() + look.x * 1.5;
        double by = this.summon.getY() + 0.15;
        double bz = this.summon.getZ() + look.z * 1.5;
        double spread = 0.03;
        level2.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, bx, by, bz, 10, look.x * spread, spread, look.z * spread, 0.0125);
    }

    @Override
    protected int attackDelay() {
        return 26;
    }

    @Override
    protected Class<? extends CompanionSummonEntity> summonType() {
        return NetherBullfrogEntity.class;
    }
}

