/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.generic;

import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.config.CompanionsConfig;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class CompanionFollowOwnerGoal
extends Goal {
    public static final int TELEPORT_WHEN_DISTANCE_IS = CompanionsConfig.COMPANIONS_FOLLOW_OWNER_TELEPORT_DISTANCE;
    protected final CompanionEntity tamable;
    protected LivingEntity owner;
    protected final LevelReader level;
    protected final double speedModifier;
    protected final PathNavigation navigation;
    protected int timeToRecalcPath;
    protected final float stopDistance;
    protected final float startDistance;
    protected float oldWaterCost;
    protected final boolean canFly;

    public CompanionFollowOwnerGoal(CompanionEntity pTamable, double pSpeedModifier, float pStartDistance, float pStopDistance, boolean pCanFly) {
        this.tamable = pTamable;
        this.level = pTamable.level();
        this.speedModifier = pSpeedModifier;
        this.navigation = pTamable.getNavigation();
        this.startDistance = pStartDistance;
        this.stopDistance = pStopDistance;
        this.canFly = pCanFly;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity owner = this.tamable.getOwner();
        if (this.tamable.getMainAction() != 1) {
            return false;
        }
        if (owner == null) {
            return false;
        }
        if (owner.isSpectator()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        if (this.tamable.distanceToSqr((Entity)owner) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.navigation.isDone()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        return !(this.tamable.distanceToSqr((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    protected boolean unableToMove() {
        return this.tamable.isOrderedToSit() || this.tamable.isPassenger() || this.tamable.isLeashed();
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.tamable.getPathfindingMalus(PathType.WATER);
        this.tamable.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void stop() {
        this.owner = null;
        this.navigation.stop();
        this.tamable.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    public void tick() {
        this.tamable.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.tamable.getMaxHeadXRot());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.adjustedTickDelay(10);
            if (this.tamable.distanceToSqr((Entity)this.owner) >= (double)(TELEPORT_WHEN_DISTANCE_IS * TELEPORT_WHEN_DISTANCE_IS)) {
                this.teleportToOwner();
            } else {
                this.navigation.moveTo((Entity)this.owner, this.speedModifier);
            }
        }
    }

    protected void teleportToOwner() {
        BlockPos pos = this.owner.blockPosition();
        for (int i = 0; i < 10; ++i) {
            int x = this.randomIntInclusive(-3, 3);
            int y = this.randomIntInclusive(-1, 1);
            int z = this.randomIntInclusive(-3, 3);
            if (!this.maybeTeleportTo(pos.getX() + x, pos.getY() + y, pos.getZ() + z)) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int pX, int pY, int pZ) {
        if (Math.abs((double)pX - this.owner.getX()) < 2.0 && Math.abs((double)pZ - this.owner.getZ()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(pX, pY, pZ))) {
            return false;
        }
        this.tamable.moveTo((float)pX + 0.5f, pY, (float)pZ + 0.5f, this.tamable.getYRot(), this.tamable.getXRot());
        this.navigation.stop();
        return true;
    }

    private boolean canTeleportTo(BlockPos pPos) {
        if (WalkNodeEvaluator.getPathTypeStatic((Mob)this.tamable, (BlockPos)pPos.mutable()) != PathType.WALKABLE) {
            return false;
        }
        if (!this.canFly && this.level.getBlockState(pPos.below()).getBlock() instanceof LeavesBlock) {
            return false;
        }
        return this.level.noCollision((Entity)this.tamable, this.tamable.getBoundingBox().move(pPos.subtract((Vec3i)this.tamable.blockPosition())));
    }

    private int randomIntInclusive(int pMin, int pMax) {
        return this.tamable.getRandom().nextInt(pMax - pMin + 1) + pMin;
    }
}

