/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.mage.goal;

import dev.xylonity.companions.common.entity.ai.mage.AbstractSoulMageAttackGoal;
import dev.xylonity.companions.common.entity.companion.SoulMageEntity;
import dev.xylonity.companions.common.entity.projectile.BlackHoleProjectile;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsItems;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class SoulMageBlackHoleGoal
extends AbstractSoulMageAttackGoal {
    public SoulMageBlackHoleGoal(SoulMageEntity soulMage, int minCd, int maxCd) {
        super(soulMage, minCd, maxCd, "BLACK_HOLE");
    }

    @Override
    protected void performAttack(LivingEntity target) {
        BlackHoleProjectile blackHole;
        if (target != null && (blackHole = (BlackHoleProjectile)CompanionsEntities.BLACK_HOLE_PROJECTILE.get().create(this.soulMage.level())) != null) {
            Vec3 spawnPos = this.soulMage.getEyePosition(1.0f).add(this.soulMage.getLookAngle().scale(0.5));
            blackHole.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
            blackHole.setOwner((Entity)this.soulMage);
            Vec3 dir = target.getEyePosition(1.0f).add(0.0, (double)(1.0f + this.soulMage.getRandom().nextFloat()), 0.0).subtract(spawnPos).normalize();
            float yaw = (float)(Math.atan2(dir.z, dir.x) * 57.29577951308232) - 90.0f;
            float pitch = (float)(-(Math.atan2(dir.y, Math.sqrt(dir.x * dir.x + dir.z * dir.z)) * 57.29577951308232));
            blackHole.shootFromRotation((Entity)this.soulMage, pitch, yaw, 0.0f, 0.8f, 0.0f);
            this.soulMage.level().addFreshEntity((Entity)blackHole);
        }
    }

    @Override
    protected boolean hasRequiredBook() {
        for (int i = 0; i < this.soulMage.inventory.getContainerSize(); ++i) {
            ItemStack stack = this.soulMage.inventory.getItem(i);
            if (stack.getItem() != CompanionsItems.BOOK_BLACK_HOLE.get()) continue;
            return true;
        }
        return false;
    }
}

