/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.mage.goal;

import dev.xylonity.companions.common.entity.ai.mage.AbstractSoulMageAttackGoal;
import dev.xylonity.companions.common.entity.companion.SoulMageEntity;
import dev.xylonity.companions.common.entity.projectile.MagicRayCircleProjectile;
import dev.xylonity.companions.common.entity.projectile.MagicRayPieceProjectile;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.knightlib.api.TickScheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SoulMageMagicRayGoal
extends AbstractSoulMageAttackGoal {
    public SoulMageMagicRayGoal(SoulMageEntity soulMage, int minCd, int maxCd) {
        super(soulMage, minCd, maxCd, "MAGIC_RAY");
    }

    @Override
    protected void performAttack(LivingEntity target) {
        if (target != null) {
            Vec3 baseDir = target.position().subtract(this.soulMage.position()).normalize();
            double traveled = 0.0;
            for (int i = 0; i < 30; ++i) {
                Vec3 piecePos = this.soulMage.getEyePosition(1.0f).add(baseDir).add(baseDir.scale(traveled));
                traveled += 1.0;
                BlockPos blockPos = BlockPos.containing((Position)piecePos);
                if (!this.isPassableBlock(this.soulMage.level(), blockPos)) {
                    this.spawnRayPiece(this.soulMage.level(), this.soulMage, piecePos, baseDir, i == 0);
                    break;
                }
                this.spawnRayPiece(this.soulMage.level(), this.soulMage, piecePos, baseDir, i == 0);
            }
        }
    }

    private boolean isPassableBlock(Level level, BlockPos pos) {
        return level.getBlockState(pos).getCollisionShape((BlockGetter)level, pos).isEmpty();
    }

    private void spawnRayPiece(Level pLevel, SoulMageEntity pPlayer, Vec3 piecePos, Vec3 lookVec, boolean isFirstPiece) {
        if (isFirstPiece) {
            MagicRayCircleProjectile circle = (MagicRayCircleProjectile)CompanionsEntities.MAGIC_RAY_PIECE_CIRCLE_PROJECTILE.get().create(pLevel);
            if (circle != null) {
                circle.setPos(piecePos.x, piecePos.y, piecePos.z);
                circle.setOwner((Entity)pPlayer);
                this.rotateProjectile(circle, lookVec);
                pLevel.addFreshEntity((Entity)circle);
            }
        } else {
            MagicRayPieceProjectile ray = (MagicRayPieceProjectile)CompanionsEntities.MAGIC_RAY_PIECE_PROJECTILE.get().create(pLevel);
            if (ray != null) {
                ray.setPos(piecePos.x, piecePos.y, piecePos.z);
                this.rotateProjectile(ray, lookVec);
                ray.setOwner((Entity)pPlayer);
                if (pLevel instanceof ServerLevel) {
                    ServerLevel level = (ServerLevel)pLevel;
                    TickScheduler.scheduleServer((Level)level, () -> pLevel.addFreshEntity((Entity)ray), (int)3);
                }
            }
        }
    }

    private void rotateProjectile(MagicRayPieceProjectile projectile, Vec3 direction) {
        projectile.setPitch((float)(-Math.atan2(direction.y, Math.sqrt(direction.x * direction.x + direction.z * direction.z)) * 57.29577951308232));
        projectile.setYaw((float)(Math.atan2(direction.z, direction.x) * 57.29577951308232) - 90.0f);
    }

    @Override
    protected boolean hasRequiredBook() {
        for (int i = 0; i < this.soulMage.inventory.getContainerSize(); ++i) {
            ItemStack stack = this.soulMage.inventory.getItem(i);
            if (stack.getItem() != CompanionsItems.BOOK_MAGIC_RAY.get()) continue;
            return true;
        }
        return false;
    }
}

