/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.mankh.goal;

import dev.xylonity.companions.common.entity.ai.mankh.AbstractMankhAttackGoal;
import dev.xylonity.companions.common.entity.companion.MankhEntity;
import dev.xylonity.companions.common.entity.projectile.LaserRingProjectile;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class MankhRingAttackGoal
extends AbstractMankhAttackGoal {
    public MankhRingAttackGoal(MankhEntity mankh, int minCd, int maxCd) {
        super(mankh, 21, minCd, maxCd);
    }

    @Override
    public void start() {
        super.start();
        this.mankh.setNoMovement(true);
        this.mankh.playSound(CompanionsSounds.MANKH_RING.get(), 1.5f, 1.0f);
    }

    @Override
    public void stop() {
        super.stop();
        this.mankh.setNoMovement(false);
    }

    @Override
    public boolean canUse() {
        return super.canUse() && this.mankh.getTarget() != null && this.mankh.distanceTo((Entity)this.mankh.getTarget()) <= 6.0f;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.mankh.getTarget() != null) {
            Vec3 dir = this.mankh.getTarget().getEyePosition().subtract(this.mankh.getEyePosition()).normalize();
            float yaw = (float)(Math.atan2(-dir.x, dir.z) * 180.0 / Math.PI);
            float pitch = (float)(Math.asin(-dir.y) * 180.0 / Math.PI);
            this.mankh.setYRot(yaw);
            this.mankh.setXRot(pitch);
            this.mankh.yRotO = yaw;
            this.mankh.xRotO = pitch;
        }
        if (this.mankh.getTarget() != null) {
            LivingEntity e = this.mankh.getTarget();
            this.mankh.lookAt((Entity)e, 30.0f, 30.0f);
        }
    }

    @Override
    protected void performAttack(LivingEntity target) {
        LaserRingProjectile ring = (LaserRingProjectile)CompanionsEntities.LASER_RING.get().create(this.mankh.level());
        if (ring != null) {
            ring.setPos(this.mankh.position().x, this.mankh.position().y + 0.15, this.mankh.position().z);
            ring.setOwner((Entity)this.mankh);
            this.mankh.level().addFreshEntity((Entity)ring);
        }
    }

    @Override
    protected int attackDelay() {
        return 14;
    }

    @Override
    protected int attackType() {
        return 2;
    }
}

