/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.minion.hostile.goal;

import dev.xylonity.companions.common.entity.ai.minion.hostile.AbstractHostileImpAttackGoal;
import dev.xylonity.companions.common.entity.hostile.HostileImpEntity;
import dev.xylonity.companions.common.entity.projectile.BraceProjectile;
import dev.xylonity.companions.registry.CompanionsEntities;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class HostileImpBraceAttackGoal
extends AbstractHostileImpAttackGoal {
    public HostileImpBraceAttackGoal(HostileImpEntity imp, int minCd, int maxCd) {
        super(imp, 12, minCd, maxCd);
    }

    @Override
    public void start() {
        super.start();
        this.imp.setNoMovement(true);
    }

    @Override
    public void stop() {
        super.stop();
        this.imp.setNoMovement(false);
    }

    @Override
    public void tick() {
        LivingEntity target = this.imp.getTarget();
        if (target != null) {
            this.imp.lookAt((Entity)target, 30.0f, 30.0f);
            float angle = (float)(Math.atan2(target.getZ() - this.imp.getZ(), target.getX() - this.imp.getX()) * 57.29577951308232) - 90.0f;
            this.imp.setYRot(angle);
            this.imp.yBodyRot = angle;
            this.imp.yHeadRot = angle;
            this.imp.yRotO = angle;
            this.imp.yBodyRotO = angle;
            this.imp.yHeadRotO = angle;
        }
        super.tick();
    }

    @Override
    protected void performAttack(LivingEntity target) {
        BraceProjectile projectile;
        if (this.imp.getTarget() != null && (projectile = (BraceProjectile)CompanionsEntities.BRACE_PROJECTILE.get().create(this.imp.level())) != null) {
            Vec3 spawnPos = this.imp.getEyePosition().add(this.imp.getLookAngle().scale(0.6));
            projectile.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
            projectile.setOwner((Entity)this.imp);
            projectile.setDeltaMovement(target.getEyePosition().subtract(spawnPos).normalize().scale(1.15).add(this.imp.getTarget().getDeltaMovement()));
            this.imp.level().addFreshEntity((Entity)projectile);
        }
    }

    @Override
    protected int attackDelay() {
        return 6;
    }

    @Override
    protected int attackType() {
        return 1;
    }
}

