/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.minion.tamable.minion;

import dev.xylonity.companions.common.entity.ai.minion.tamable.AbstractMinionAttackGoal;
import dev.xylonity.companions.common.entity.companion.MinionEntity;
import dev.xylonity.companions.common.entity.projectile.TornadoProjectile;
import dev.xylonity.companions.registry.CompanionsEntities;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class MinionTornadoAttackGoal
extends AbstractMinionAttackGoal {
    public MinionTornadoAttackGoal(MinionEntity minion, int minCd, int maxCd) {
        super(minion, 50, minCd, maxCd);
    }

    @Override
    public void start() {
        super.start();
        this.minion.setNoMovement(true);
    }

    @Override
    public void stop() {
        super.stop();
        this.minion.setNoMovement(false);
    }

    @Override
    protected void performAttack(LivingEntity target) {
        TornadoProjectile tornado;
        if (this.minion.getOwner() != null && (tornado = (TornadoProjectile)CompanionsEntities.TORNADO_PROJECTILE.get().create(this.minion.level())) != null) {
            Vec3 startPos = this.minion.getEyePosition(1.0f);
            Vec3 spawnPos = startPos.add(target.getEyePosition(1.0f).subtract(startPos).normalize());
            tornado.moveTo(spawnPos.x, spawnPos.y - 1.0, spawnPos.z);
            tornado.setOwner((Entity)this.minion);
            this.minion.level().addFreshEntity((Entity)tornado);
        }
    }

    @Override
    protected int attackDelay() {
        return 12;
    }

    @Override
    protected String variant() {
        return MinionEntity.Variant.OVERWORLD.getName();
    }

    @Override
    protected int attackType() {
        return 1;
    }
}

