/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.pontiff.goal;

import dev.xylonity.companions.common.entity.ai.pontiff.AbstractSacredPontiffAttackGoal;
import dev.xylonity.companions.common.entity.hostile.SacredPontiffEntity;
import dev.xylonity.companions.common.entity.projectile.HolinessStartProjectile;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class HolinessStarAttackGoal
extends AbstractSacredPontiffAttackGoal {
    public HolinessStarAttackGoal(SacredPontiffEntity boss, int minCd, int maxCd) {
        super(boss, 40, minCd, maxCd);
    }

    @Override
    public void start() {
        super.start();
        this.pontiff.setNoMovement(true);
        this.pontiff.setShouldLookAtTarget(false);
        this.pontiff.playSound(CompanionsSounds.HOLINESS_STAR_SPAWN.get());
    }

    @Override
    public void stop() {
        super.stop();
        this.pontiff.setNoMovement(false);
        this.pontiff.setShouldLookAtTarget(true);
    }

    @Override
    public boolean canUse() {
        return super.canUse() && this.pontiff.getTarget() != null && this.pontiff.distanceTo((Entity)this.pontiff.getTarget()) < 25.0f && HolinessStarAttackGoal.isEntityInFront((LivingEntity)this.pontiff, (Entity)this.pontiff.getTarget(), 160.0);
    }

    @Override
    protected int getAttackType() {
        return 5;
    }

    @Override
    protected void performAttack(LivingEntity target) {
        Vec3 basePos = this.pontiff.position().add(0.0, (double)this.pontiff.getEyeHeight(), 0.0);
        Vec3 targetPos = target.position().add(0.0, (double)target.getEyeHeight(), 0.0);
        Vec3 dir = targetPos.subtract(basePos).normalize();
        Vec3 perpen = new Vec3(-dir.z, 0.0, dir.x).normalize();
        for (float side : new float[]{-1.5f, 1.5f}) {
            Vec3 spawnPos = basePos.add(perpen.scale((double)side));
            Vec3 vel = targetPos.subtract(spawnPos).normalize().add(perpen.scale((double)side * 0.3)).normalize().scale((double)HolinessStartProjectile.SPEED);
            HolinessStartProjectile star = (HolinessStartProjectile)CompanionsEntities.HOLINESS_STAR.get().create(this.pontiff.level());
            if (star == null) continue;
            star.setOwner((Entity)this.pontiff);
            star.setTarget(target);
            star.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
            star.setDeltaMovement(vel);
            star.setNoGravity(true);
            star.setRed(new Random().nextBoolean());
            this.pontiff.level().addFreshEntity((Entity)star);
        }
    }

    @Override
    protected int attackDelay() {
        return 18;
    }

    @Override
    protected int attackState() {
        return 6;
    }
}

