/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.pontiff.goal;

import dev.xylonity.companions.common.entity.hostile.SacredPontiffEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class PontiffStrafeAroundTargetGoal
extends Goal {
    private final SacredPontiffEntity pontiff;
    private final double speed;
    private final float radiusSqr;
    private int seeTime;
    private boolean clockwise;
    private boolean backwards;
    private int strafeTime = -1;

    public PontiffStrafeAroundTargetGoal(SacredPontiffEntity mob, double speed, float radius) {
        this.pontiff = mob;
        this.speed = speed;
        this.radiusSqr = (float)Math.pow(radius, 2.0);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.pontiff.getTarget() == null) {
            return false;
        }
        if (this.pontiff.getAttackType() != 0) {
            return false;
        }
        return this.pontiff.shouldSearchTarget();
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        LivingEntity target = this.pontiff.getTarget();
        if (target == null) {
            return;
        }
        double distSqr = this.pontiff.distanceToSqr((Entity)target);
        boolean canSee = this.pontiff.getSensing().hasLineOfSight((Entity)target);
        int n = this.seeTime = canSee ? Math.min(this.seeTime + 1, 20) : this.seeTime - 1;
        if (distSqr <= (double)this.radiusSqr && this.seeTime >= 20) {
            this.pontiff.getNavigation().stop();
            ++this.strafeTime;
        } else {
            this.pontiff.getNavigation().moveTo((Entity)target, this.speed);
            this.strafeTime = -1;
        }
        if (this.strafeTime >= 20) {
            if ((double)this.pontiff.getRandom().nextFloat() < 0.3) {
                boolean bl = this.clockwise = !this.clockwise;
            }
            if ((double)this.pontiff.getRandom().nextFloat() < 0.3) {
                this.backwards = !this.backwards;
            }
            this.strafeTime = 0;
        }
        if (this.strafeTime > -1) {
            if (distSqr > (double)(this.radiusSqr * 0.75f)) {
                this.backwards = false;
            } else if (distSqr < (double)(this.radiusSqr * 0.25f)) {
                this.backwards = true;
            }
            this.pontiff.getMoveControl().strafe(this.backwards ? -0.5f : 0.5f, this.clockwise ? 0.5f : -0.5f);
            if (!this.pontiff.onGround()) {
                this.pontiff.setDeltaMovement(this.pontiff.getDeltaMovement().x, this.pontiff.getDeltaMovement().y - 0.3, this.pontiff.getDeltaMovement().z);
            }
            if (this.pontiff.shouldLookAtTarget()) {
                this.pontiff.lookAt((Entity)target, 30.0f, 30.0f);
            }
        } else if (this.pontiff.shouldLookAtTarget()) {
            this.pontiff.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        }
    }
}

