/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.shade.sword.goal;

import dev.xylonity.companions.common.entity.ShadeEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class ShadeSwordFollowTargetGoal
extends Goal {
    private static final double MIN_RADIUS = 3.0;
    private static final double AMP_RADIUS = 2.0;
    private static final double RADIUS_FREQ = 0.45;
    private static final double ANG_SPEED = 0.12;
    private final ShadeEntity sword;
    private LivingEntity owner;
    private LivingEntity target;
    private double angle = 0.0;
    private double time = 0.0;
    private final int dir;

    public ShadeSwordFollowTargetGoal(ShadeEntity sword) {
        this.sword = sword;
        this.dir = sword.getRandom().nextBoolean() ? 1 : -1;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean canUse() {
        if (this.sword.isSpawning()) {
            return false;
        }
        this.owner = this.sword.getOwner();
        this.target = this.sword.getTarget() != null ? this.sword.getTarget() : null;
        return this.owner != null && this.target != null && this.target.isAlive();
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public void tick() {
        if (this.sword.shouldLookAtTarget()) {
            this.sword.lookAt((Entity)this.target, 30.0f, 30.0f);
        }
        Vec3 c = new Vec3(this.target.getX(), this.target.getY() + (double)this.target.getBbHeight() * 0.5, this.target.getZ());
        this.time += 0.04;
        double r = 3.0 + 1.0 * (1.0 + Math.sin(this.time * 0.45 * 2.0 * Math.PI));
        this.angle = (this.angle + 0.12 * (double)this.dir) % (Math.PI * 2);
        Vec3 lerped = c.add(r * Math.cos(this.angle), 0.0, r * Math.sin(this.angle));
        Vec3 nextPos = this.sword.position().lerp(lerped, 0.1);
        this.sword.setPos(nextPos.x, nextPos.y, nextPos.z);
        this.sword.setDeltaMovement(Vec3.ZERO);
    }

    public void stop() {
        this.sword.setDeltaMovement(Vec3.ZERO);
        super.stop();
    }
}

