/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.teddy;

import dev.xylonity.companions.common.entity.companion.TeddyEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public abstract class AbstractTeddyAttackGoal
extends Goal {
    protected final TeddyEntity teddy;
    protected int attackDuration;
    protected final int minCooldown;
    protected final int maxCooldown;
    protected int attackTicks;
    protected int nextUseTick;
    protected boolean started;

    public AbstractTeddyAttackGoal(TeddyEntity teddy, int attackDuration, int minCd, int maxCd) {
        this.teddy = teddy;
        this.attackDuration = attackDuration;
        this.minCooldown = minCd;
        this.maxCooldown = maxCd;
        this.nextUseTick = -1;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.phase() != this.teddy.getPhase()) {
            return false;
        }
        if (this.teddy.getAttackType() != 0) {
            return false;
        }
        if (this.teddy.getTarget() == null) {
            return false;
        }
        if (this.teddy.getMainAction() != 1) {
            return false;
        }
        if (this.nextUseTick < 0) {
            this.nextUseTick = this.teddy.tickCount + this.minCooldown + this.teddy.getRandom().nextInt(this.maxCooldown - this.minCooldown + 1);
            return false;
        }
        return this.teddy.tickCount >= this.nextUseTick;
    }

    public boolean canContinueToUse() {
        return this.started && this.attackTicks < this.attackDuration;
    }

    public void start() {
        this.attackTicks = 0;
        this.started = true;
        this.teddy.setAttackType(this.getAttackType());
    }

    public void stop() {
        this.started = false;
        this.teddy.setAttackType(0);
        int cd = this.minCooldown + this.teddy.getRandom().nextInt(this.maxCooldown - this.minCooldown + 1);
        this.nextUseTick = this.teddy.tickCount + cd;
    }

    public void tick() {
        LivingEntity target = this.teddy.getTarget();
        if (target != null) {
            this.teddy.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        }
        if (this.attackTicks == this.attackDelay() && target != null && target.isAlive()) {
            this.performAttack(target);
        }
        ++this.attackTicks;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    protected abstract void performAttack(LivingEntity var1);

    protected abstract int attackDelay();

    protected abstract int phase();

    protected abstract int getAttackType();
}

