/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.teddy.goal;

import dev.xylonity.companions.common.entity.companion.TeddyEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class MutatedTeddyRandomStrollGoal
extends Goal {
    protected final TeddyEntity teddy;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    protected final double speedModifier;
    protected int interval;
    protected boolean forceTrigger;
    private final boolean checkNoActionTime;
    private final float lerpFactor;
    private Vec3 targetPos;

    public MutatedTeddyRandomStrollGoal(TeddyEntity teddy, double speedModifier, int interval, boolean checkNoActionTime, float lerpFactor) {
        this.teddy = teddy;
        this.speedModifier = speedModifier;
        this.interval = interval;
        this.checkNoActionTime = checkNoActionTime;
        this.lerpFactor = lerpFactor;
        this.forceTrigger = false;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public MutatedTeddyRandomStrollGoal(TeddyEntity teddy, double speedModifier) {
        this(teddy, speedModifier, 120, false, 0.1f);
    }

    public boolean canUse() {
        Vec3 pos;
        if (this.teddy.getMainAction() != 2 || this.teddy.getPhase() != 2) {
            return false;
        }
        if (this.teddy.isVehicle()) {
            return false;
        }
        if (!this.forceTrigger) {
            if (this.checkNoActionTime && this.teddy.getNoActionTime() >= 100) {
                return false;
            }
            if (this.teddy.getRandom().nextInt(MutatedTeddyRandomStrollGoal.reducedTickDelay((int)this.interval)) != 0) {
                return false;
            }
        }
        if ((pos = this.getPosition()) == null) {
            return false;
        }
        this.wantedX = pos.x;
        this.wantedY = pos.y;
        this.wantedZ = pos.z;
        this.forceTrigger = false;
        return true;
    }

    @Nullable
    protected Vec3 getPosition() {
        Vec3 raw = DefaultRandomPos.getPos((PathfinderMob)this.teddy, (int)5, (int)1);
        if (raw == null) {
            return null;
        }
        BlockPos topP = this.teddy.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos((int)raw.x, (int)raw.y, (int)raw.z));
        return new Vec3(raw.x, (double)topP.getY() + 1.0 + this.teddy.getRandom().nextDouble() * 2.0, raw.z);
    }

    public void start() {
        this.targetPos = new Vec3(this.wantedX, this.wantedY, this.wantedZ);
        this.teddy.noPhysics = true;
    }

    public boolean canContinueToUse() {
        double dz;
        double dy;
        if (this.teddy.getMainAction() != 2 || this.teddy.getPhase() != 2) {
            return false;
        }
        if (this.teddy.isVehicle() || this.targetPos == null) {
            return false;
        }
        double dx = this.targetPos.x - this.teddy.getX();
        return dx * dx + (dy = this.targetPos.y - this.teddy.getY()) * dy + (dz = this.targetPos.z - this.teddy.getZ()) * dz > 1.0;
    }

    public void tick() {
        if (this.targetPos == null) {
            return;
        }
        this.teddy.lookAt(EntityAnchorArgument.Anchor.EYES, this.targetPos);
        Vec3 delta = this.targetPos.subtract(this.teddy.position());
        Vec3 dir = delta.scale(1.0 / delta.length());
        Vec3 vel = dir.scale(this.speedModifier);
        Vec3 cur = this.teddy.getDeltaMovement();
        double vx = Mth.lerp((double)this.lerpFactor, (double)cur.x, (double)vel.x);
        double vy = Mth.lerp((double)this.lerpFactor, (double)cur.y, (double)vel.y);
        double vz = Mth.lerp((double)this.lerpFactor, (double)cur.z, (double)vel.z);
        this.teddy.setDeltaMovement(vx, vy, vz);
    }

    public void stop() {
        this.teddy.noPhysics = false;
        this.targetPos = null;
    }

    public void trigger() {
        this.forceTrigger = true;
    }
}

