/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ai.generic.CompanionFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionRandomStrollGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.common.entity.ai.puppet.glove.goal.PuppetGloveAttackGoal;
import dev.xylonity.companions.common.entity.companion.PuppetEntity;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsBlocks;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class PuppetGloveEntity
extends CompanionEntity {
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation ATTACK = RawAnimation.begin().thenPlay("attack");
    private final RawAnimation SIT = RawAnimation.begin().thenPlay("sit");
    private final RawAnimation RECEIVE_PUPPET = RawAnimation.begin().thenPlay("recieve_puppet");
    private static final EntityDataAccessor<Boolean> IS_ATTACKING = SynchedEntityData.defineId(PuppetGloveEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> TRANSFORMING = SynchedEntityData.defineId(PuppetGloveEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final int TRANSFORMATION_TICKS = 25;
    private int transformationCounter = -1;

    public PuppetGloveEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.transformationCounter != -1) {
                ++this.transformationCounter;
            }
            if (this.transformationCounter == 25) {
                this.tameGlove(this.getOwner());
            }
        }
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 1;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return CompanionsConfig.PUPPET_GLOVE_KEEP_CHUNK_LOADED;
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    protected void playStepSound(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.playSound(CompanionsSounds.PUPPET_GLOVE_STEP.get());
    }

    public static AttributeSupplier setAttributes() {
        return TamableAnimal.createMobAttributes().add(Attributes.MAX_HEALTH, CompanionsConfig.PUPPET_GLOVE_MAX_LIFE).add(Attributes.ATTACK_DAMAGE, CompanionsConfig.PUPPET_GLOVE_DAMAGE).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.55f).add(Attributes.FOLLOW_RANGE, 35.0).build();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PuppetGloveAttackGoal(this, 10, 40));
        this.goalSelector.addGoal(3, (Goal)new CompanionFollowOwnerGoal(this, 0.6, 6.0f, 2.0f, false));
        this.goalSelector.addGoal(3, (Goal)new CompanionRandomStrollGoal(this, 0.43));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new CompanionsHurtTargetGoal(this));
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.isTransforming()) {
            return InteractionResult.PASS;
        }
        Item item = player.getItemInHand(hand).getItem();
        if (item == CompanionsBlocks.EMPTY_PUPPET.get().asItem() && this.isTame() && this.getOwner() != null && this.getOwner() == player) {
            if (this.level().isClientSide) {
                return InteractionResult.SUCCESS;
            }
            this.setOwnerUUID(player.getUUID());
            this.setTransforming(true);
            ++this.transformationCounter;
            return InteractionResult.SUCCESS;
        }
        if (this.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleDefaultMainActionAndHeal(player, hand)) {
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    private void tameGlove(LivingEntity player) {
        PuppetEntity puppet = (PuppetEntity)CompanionsEntities.PUPPET.get().create(this.level());
        if (puppet != null) {
            puppet.moveTo(this.position());
            if (player instanceof Player) {
                Player p = (Player)player;
                puppet.tameInteraction(p);
            } else if (this.getOwner() == null && this.getOwnerUUID() != null) {
                puppet.setOwnerUUID(this.getOwnerUUID());
            }
            this.level().addFreshEntity((Entity)puppet);
        }
        this.generatePoofParticles();
        this.discard();
    }

    private void generatePoofParticles() {
        for (int i = 0; i < 30; ++i) {
            double dx = (this.random.nextDouble() - 0.5) * 1.25;
            double dy = (this.random.nextDouble() - 0.5) * 1.25;
            double dz = (this.random.nextDouble() - 0.5) * 1.25;
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            level2.sendParticles((ParticleOptions)ParticleTypes.POOF, this.position().x, this.getY() + (double)this.getBbHeight() * Math.random(), this.position().z, 1, dx, dy, dz, 0.1);
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_ATTACKING, (Object)false);
        builder.define(TRANSFORMING, (Object)false);
    }

    public boolean isAttacking() {
        return (Boolean)this.entityData.get(IS_ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.entityData.set(IS_ATTACKING, (Object)attacking);
    }

    public boolean isTransforming() {
        return (Boolean)this.entityData.get(TRANSFORMING);
    }

    public void setTransforming(boolean transforming) {
        this.entityData.set(TRANSFORMING, (Object)transforming);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.isTransforming()) {
            event.getController().setAnimation(this.RECEIVE_PUPPET);
        } else if (this.isAttacking()) {
            event.getController().setAnimation(this.ATTACK);
        } else if (this.getMainAction() == 0) {
            event.getController().setAnimation(this.SIT);
        } else if (event.isMoving()) {
            event.getController().setAnimation(this.WALK);
        } else {
            event.getController().setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

