/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ShadeEntity;
import dev.xylonity.companions.common.entity.ai.generic.CompanionFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import dev.xylonity.knightlib.api.TickScheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class ShadeMawEntity
extends ShadeEntity
implements PlayerRideableJumping {
    private final RawAnimation SPAWN = RawAnimation.begin().thenPlay("spawn");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation RUN = RawAnimation.begin().thenPlay("run");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation BITE = RawAnimation.begin().thenPlay("bite");
    private final RawAnimation SWIM = RawAnimation.begin().thenPlay("swim");
    private static final int ANIMATION_SPAWN_MAX_TICKS = 130;
    private static final float WALK_THETA = 0.02f;
    private static final float RUN_THETA = 0.375f;
    private static final float ACCEL = 0.02f;
    private static final float LIQUID_DRAG = 0.9f;
    private float throttle = 0.0f;
    private boolean canJump = true;
    private int jumpCharge = 0;
    private boolean hasSpawned = false;

    public ShadeMawEntity(EntityType<? extends CompanionEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.noCulling = true;
        this.setBoundingBox(this.makeBoundingBox());
    }

    @Override
    public int getMaxLifetime() {
        return CompanionsConfig.SHADOW_MAW_LIFETIME;
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    @NotNull
    public AABB makeBoundingBox() {
        float hw = (float)((double)this.getBbWidth() * 0.8 / 2.0);
        return new AABB(this.getX() - (double)hw, this.getY(), this.getZ() - (double)hw, this.getX() + (double)hw, this.getY() + (double)this.getBbHeight(), this.getZ() + (double)hw);
    }

    public float getPickRadius() {
        return (float)(((double)this.getBbWidth() - (double)this.getBbWidth() * 0.8) * 0.5);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new CompanionFollowOwnerGoal(this, 0.6, 10.0f, 4.0f, false){

            @Override
            public boolean canUse() {
                return super.canUse() && !ShadeMawEntity.this.isSpawning();
            }
        });
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new CompanionsHurtTargetGoal(this));
    }

    public static AttributeSupplier setAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, CompanionsConfig.SHADOW_MAW_MAX_LIFE).add(Attributes.ATTACK_DAMAGE, CompanionsConfig.SHADOW_MAW_DAMAGE).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.45f).add(Attributes.STEP_HEIGHT, (double)1.1f).add(Attributes.FOLLOW_RANGE, 35.0).build();
    }

    protected void playHurtSound(@NotNull DamageSource pSource) {
        this.playSound(CompanionsSounds.SHADE_HURT.get());
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return CompanionsSounds.SHADE_IDLE.get();
    }

    protected void playStepSound(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        if (this.getDeltaMovement().horizontalDistanceSqr() > 0.140625) {
            if (this.tickCount % 5 == 0) {
                this.playSound(CompanionsSounds.SHADE_STEP.get(), 2.0f, 1.0f);
            }
        } else {
            this.playSound(CompanionsSounds.SHADE_STEP.get(), 2.0f, 1.0f);
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.setAirSupply(this.getMaxAirSupply());
        if (this.level().isClientSide) {
            Companions.PROXY.tickShadeMaw(this);
        }
        if (!this.hasSpawned && this.isSpawning()) {
            TickScheduler.scheduleServer((Level)this.level(), () -> this.setIsSpawning(false), (int)130);
            TickScheduler.scheduleBoth((Level)this.level(), () -> ((ShadeMawEntity)this).refreshDimensions(), (int)110);
            TickScheduler.scheduleServer((Level)this.level(), () -> this.setInvisible(false), (int)5);
            this.hasSpawned = true;
        }
        if (this.tickCount % 6 == 0 && !this.isSpawning()) {
            double dx = (this.random.nextDouble() - 0.5) * (double)this.getBbWidth();
            double dy = (this.random.nextDouble() - 0.5) * (double)this.getBbWidth();
            double dz = (this.random.nextDouble() - 0.5) * (double)this.getBbWidth();
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                level2.sendParticles((ParticleOptions)CompanionsParticles.SHADE_TRAIL.get(), this.getX(), this.getY() + (double)this.getBbHeight() * Math.random(), this.getZ(), 1, dx, dy, dz, 0.1);
            }
        }
        this.setLifetime(this.getLifetime() - 1);
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity;
        if (!this.isNoAi() && (entity = this.getFirstPassenger()) instanceof LivingEntity) {
            LivingEntity e = (LivingEntity)entity;
            return e;
        }
        return null;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean canCollideWith(@NotNull Entity pEntity) {
        if (pEntity == this.getFirstPassenger()) {
            return false;
        }
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            return player.equals((Object)this.getOwner());
        }
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean isPickable() {
        return true;
    }

    public void travel(@NotNull Vec3 travelVec) {
        LivingEntity rider = this.getControllingPassenger();
        if (rider == null && !this.level().getFluidState(this.blockPosition()).isEmpty()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.8));
            this.setSwimming(true);
            super.travel(Vec3.ZERO);
            return;
        }
        if (this.isVehicle() && rider != null && !this.isSpawning()) {
            this.setYRot(rider.getYRot());
            this.yBodyRot = this.yRotO = this.getYRot();
            float strafe = rider.xxa * 0.5f;
            float forward = rider.zza;
            if (forward < 0.0f) {
                forward *= 0.25f;
            }
            this.throttle = Math.abs(forward) > 0.001f || Math.abs(strafe) > 0.001f ? Mth.clamp((float)(this.throttle + 0.02f), (float)0.0f, (float)1.0f) : Mth.clamp((float)(this.throttle - 0.03f), (float)0.0f, (float)1.0f);
            if (this.horizontalCollision && !this.isInFluidType()) {
                this.throttle = 0.3525f;
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.0, 1.0, 0.0));
            }
            if (this.isInFluidType()) {
                double len;
                float speed = (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) * (0.6f + 0.2f * this.throttle);
                Vec3 lookDir = rider.getLookAngle().normalize();
                Vec3 motion = lookDir.scale((double)(speed * forward));
                if (Math.abs(strafe) > 0.001f) {
                    motion = motion.add(new Vec3(0.0, 1.0, 0.0).cross(lookDir).normalize().scale((double)(speed * strafe)));
                }
                if (this.isOnLiquidSurface() && forward > 0.05f) {
                    Vec3 fHoriz = new Vec3(lookDir.x, 0.0, lookDir.z).normalize();
                    BlockPos inFront = BlockPos.containing((double)(this.getX() + fHoriz.x * 0.8), (double)(this.getY() + 0.2), (double)(this.getZ() + fHoriz.z * 0.8));
                    motion = this.level().getFluidState(inFront).isEmpty() ? motion.add(0.0, 0.26, 0.0).add(fHoriz.scale(0.05)) : motion.add(0.0, 0.03, 0.0);
                }
                if (this.horizontalCollision) {
                    double upAmount = this.isOnLiquidSurface() ? Math.max(0.22, (double)speed * 0.35) : Math.max(0.12, (double)speed * 0.25);
                    Vec3 right = new Vec3(0.0, 1.0, 0.0).cross(lookDir).normalize();
                    motion = motion.add(0.0, upAmount, 0.0).add(right.scale((double)(speed * 0.2f * (float)(strafe >= 0.0f ? 1 : -1))));
                }
                if ((len = motion.length()) > 0.9) {
                    motion = motion.scale(0.9 / len);
                }
                this.setXRot((float)(-Math.toDegrees(Math.atan2(motion.y, Math.sqrt(motion.x * motion.x + motion.z * motion.z)))));
                this.move(MoverType.SELF, motion);
                this.setDeltaMovement(this.getDeltaMovement().scale((double)0.9f));
                this.setSwimming(true);
            } else {
                this.setSpeed((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) * this.throttle);
                super.travel(new Vec3((double)strafe, travelVec.y, (double)Math.signum(forward)));
            }
            return;
        }
        super.travel(travelVec);
    }

    protected void tickRidden(@NotNull Player rider, @NotNull Vec3 travelVector) {
        super.tickRidden(rider, travelVector);
        if (rider.getEffect(MobEffects.FIRE_RESISTANCE) == null) {
            rider.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 10, 0, false, false));
        }
        if (this.isInAnyFluid()) {
            rider.setPose(Pose.SWIMMING);
        }
        if (rider.isInWater()) {
            rider.setAirSupply(rider.getMaxAirSupply());
        }
        if (rider.isInLava()) {
            rider.extinguishFire();
            rider.clearFire();
        }
        if (!this.level().isClientSide && rider.swinging && rider.getMainHandItem().isEmpty()) {
            this.doAttack();
            rider.swinging = false;
        }
        if (this.jumpCharge > 0 && this.canJump && this.onGround()) {
            double yStr;
            if (this.isOnLiquidSurface()) {
                yStr = 0.5;
            } else if (this.onGround()) {
                yStr = 0.25 + 0.008 * (double)this.jumpCharge;
            } else {
                return;
            }
            this.setDeltaMovement(this.getDeltaMovement().x, yStr, this.getDeltaMovement().z);
            this.hasImpulse = true;
            this.jumpCharge = 0;
        }
    }

    private void doAttack() {
        if (this.getAttackType() != 1) {
            this.setAttackType(1);
            TickScheduler.scheduleServer((Level)this.level(), () -> this.setAttackType(0), (int)12);
            TickScheduler.scheduleServer((Level)this.level(), () -> {
                for (Entity e : this.level().getEntitiesOfClass(Entity.class, new AABB(this.blockPosition()).inflate(3.0))) {
                    LivingEntity livingEntity;
                    if (!(e instanceof LivingEntity) || !this.hasLineOfSight((Entity)(livingEntity = (LivingEntity)e)) || !ShadeMawEntity.isEntityInFront((LivingEntity)this, (Entity)livingEntity, 150.0) || livingEntity == this) continue;
                    this.doHurtTarget((Entity)livingEntity);
                    livingEntity.knockback(0.5, this.getX() - livingEntity.getX(), this.getZ() - livingEntity.getZ());
                }
            }, (int)10);
            this.playSound(CompanionsSounds.SHADE_MAW_BITE.get(), 0.3325f, 1.0f);
        }
    }

    public static boolean isEntityInFront(LivingEntity viewer, Entity target, double fov) {
        Vec3 toTarget;
        Vec3 view = viewer.getLookAngle().normalize();
        double angle = Math.acos(view.dot(toTarget = target.position().add(0.0, (double)target.getEyeHeight() * 0.5, 0.0).subtract(viewer.getEyePosition(1.0f)).normalize())) * 57.29577951308232;
        return angle < fov / 2.0;
    }

    @NotNull
    public InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        if (!player.isSecondaryUseActive() && !player.isShiftKeyDown() && this.getOwner() != null && player.equals((Object)this.getOwner())) {
            if (!this.level().isClientSide && !this.isSpawning()) {
                player.startRiding((Entity)this, true);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    protected void positionRider(@NotNull Entity pPassenger, @NotNull Entity.MoveFunction pCallback) {
        if (this.hasPassenger(pPassenger)) {
            double baseY = this.getY() + 1.5;
            if (this.isInAnyFluid()) {
                baseY -= 1.35;
            }
            pCallback.accept(pPassenger, this.getX(), baseY + 0.5, this.getZ());
        }
    }

    public void onPlayerJump(int strength) {
        if (strength > 0) {
            this.jumpCharge = Mth.clamp((int)strength, (int)0, (int)100);
            if (this.isOnLiquidSurface()) {
                this.setDeltaMovement(this.getDeltaMovement().x, 0.5, this.getDeltaMovement().z);
                this.hasImpulse = true;
                this.jumpCharge = 0;
            }
        }
    }

    private boolean isOnLiquidSurface() {
        if (!this.isInAnyFluid()) {
            return false;
        }
        BlockPos pos = this.blockPosition();
        BlockPos abovePos = pos.above();
        FluidState fluidState = this.level().getFluidState(pos);
        FluidState aboveFluidState = this.level().getFluidState(abovePos);
        return !fluidState.isEmpty() && aboveFluidState.isEmpty();
    }

    public boolean canJump() {
        return this.canJump && (this.onGround() || this.isOnLiquidSurface());
    }

    public void handleStartJump(int strength) {
        this.jumpCharge = strength;
        this.canJump = false;
    }

    public void handleStopJump() {
        this.canJump = true;
    }

    public int getJumpCooldown() {
        return 0;
    }

    protected boolean canAddPassenger(@NotNull Entity pPassenger) {
        return super.canAddPassenger(pPassenger);
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return false;
    }

    protected void checkFallDamage(double pY, boolean pOnGround, @NotNull BlockState pState, @NotNull BlockPos pPos) {
    }

    public void knockback(double pStrength, double pX, double pZ) {
        if (!this.isSpawning()) {
            super.knockback(pStrength, pX, pZ);
        }
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 1;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "attackcontroller", 2, this::attackPredicate));
    }

    public boolean isInAnyFluid() {
        Vec3 eyePos = this.getEyePosition(1.0f);
        return !this.level().getFluidState(new BlockPos((int)eyePos.x, (int)eyePos.y, (int)eyePos.z)).isEmpty();
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        double speed = this.getDeltaMovement().horizontalDistanceSqr();
        if (this.isSpawning()) {
            event.setAnimation(this.SPAWN);
        } else if (this.isInAnyFluid()) {
            event.setAnimation(this.SWIM);
        } else if (speed > 0.140625) {
            event.setAnimation(this.RUN);
        } else if (speed > (double)4.0E-4f) {
            event.setAnimation(this.WALK);
        } else {
            event.setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState attackPredicate(AnimationState<T> event) {
        if (this.getAttackType() == 1 && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.setAnimation(this.BITE);
        }
        return PlayState.CONTINUE;
    }
}

