/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.hostile;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.HostileEntity;
import dev.xylonity.companions.common.entity.ai.minion.hostile.goal.HostileImpBraceAttackGoal;
import dev.xylonity.companions.common.entity.ai.minion.hostile.goal.HostileImpFireMarkAttackGoal;
import dev.xylonity.companions.common.entity.companion.MinionEntity;
import dev.xylonity.companions.common.entity.projectile.ShadeAltarUpgradeHaloProjectile;
import dev.xylonity.companions.registry.CompanionsBlocks;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class HostileImpEntity
extends HostileEntity {
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation THROW = RawAnimation.begin().thenPlay("throw");
    private final RawAnimation RING = RawAnimation.begin().thenPlay("ring");
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.defineId(HostileImpEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> ANGRY = SynchedEntityData.defineId(HostileImpEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final int ANGRY_MAX_TICKS = 300;
    private int angryCounter = -1;

    public HostileImpEntity(EntityType<? extends HostileEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.isAngry() && this.angryCounter == -1) {
                ++this.angryCounter;
            }
            if (this.angryCounter >= 300) {
                this.angryCounter = -1;
                this.setAngry(false);
                this.setTarget(null);
                this.failureParticles();
            }
            if (this.angryCounter != -1) {
                ++this.angryCounter;
            }
        }
    }

    public static AttributeSupplier setAttributes() {
        return HostileEntity.createMobAttributes().add(Attributes.MAX_HEALTH, 35.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.55f).add(Attributes.FOLLOW_RANGE, 35.0).build();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new HostileImpBraceAttackGoal(this, 20, 90));
        this.goalSelector.addGoal(1, (Goal)new HostileImpFireMarkAttackGoal(this, 20, 160));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.43));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            public boolean canUse() {
                return super.canUse() && HostileImpEntity.this.isAngry();
            }
        });
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        InteractionResult interactionResult = super.mobInteract(player, hand);
        if (!this.isAngry()) {
            if (item == CompanionsBlocks.COPPER_COIN.get().asItem()) {
                interactionResult = this.handleCoinInteraction(this.level().random.nextFloat() < 0.25f, player);
            } else if (item == CompanionsBlocks.NETHER_COIN.get().asItem()) {
                interactionResult = this.handleCoinInteraction(this.level().random.nextFloat() < 0.5f, player);
            } else if (item == CompanionsBlocks.END_COIN.get().asItem()) {
                interactionResult = this.handleCoinInteraction(this.level().random.nextFloat() < 0.8f, player);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"hostile_imp.companions.client_message.requires_coin"), true);
            }
        }
        return interactionResult;
    }

    private InteractionResult handleCoinInteraction(boolean tame, Player player) {
        if (this.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (tame) {
            this.tameImp(player);
            this.tameParticles();
            this.discard();
        } else {
            this.setAngry(true);
            this.failureParticles();
            ShadeAltarUpgradeHaloProjectile halo = (ShadeAltarUpgradeHaloProjectile)CompanionsEntities.SHADE_ALTAR_UPGRADE_HALO.get().create(this.level());
            if (halo != null) {
                halo.moveTo(this.position());
                this.level().addFreshEntity((Entity)halo);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        return false;
    }

    private void tameParticles() {
        for (int i = 0; i < 20; ++i) {
            double dx = (this.random.nextDouble() - 0.5) * 2.0;
            double dy = (this.random.nextDouble() - 0.5) * 2.0;
            double dz = (this.random.nextDouble() - 0.5) * 2.0;
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            if (level2.random.nextFloat() < 0.65f) {
                level2.sendParticles((ParticleOptions)ParticleTypes.POOF, this.getX(), this.getY() + (double)this.getBbHeight() * Math.random(), this.getZ(), 1, dx, dy, dz, 0.1);
            }
            if (!(level2.random.nextFloat() < 0.25f)) continue;
            level2.sendParticles((ParticleOptions)CompanionsParticles.SHADE_SUMMON.get(), this.getX(), this.getY() + (double)this.getBbHeight() * Math.random(), this.getZ(), 1, dx, dy, dz, 0.2);
        }
    }

    private void failureParticles() {
        for (int i = 0; i < 20; ++i) {
            double dx = (this.random.nextDouble() - 0.5) * 2.0;
            double dy = (this.random.nextDouble() - 0.5) * 2.0;
            double dz = (this.random.nextDouble() - 0.5) * 2.0;
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            if (!(level2.random.nextFloat() < 0.65f)) continue;
            level2.sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY() + (double)this.getBbHeight() * Math.random(), this.getZ(), 1, dx, dy, dz, 0.025);
        }
    }

    private void tameImp(Player player) {
        MinionEntity minion = (MinionEntity)CompanionsEntities.MINION.get().create(this.level());
        if (minion != null) {
            minion.moveTo(this.position());
            minion.tameInteraction(player);
            this.level().addFreshEntity((Entity)minion);
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ATTACK_TYPE, (Object)0);
        builder.define(ANGRY, (Object)false);
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (pSource.getEntity() != null) {
            this.setAngry(true);
        }
        return super.hurt(pSource, pAmount);
    }

    public int getAttackType() {
        return (Integer)this.entityData.get(ATTACK_TYPE);
    }

    public void setAttackType(int attacking) {
        this.entityData.set(ATTACK_TYPE, (Object)attacking);
    }

    public boolean isAngry() {
        return (Boolean)this.entityData.get(ANGRY);
    }

    public void setAngry(boolean isAngry) {
        this.entityData.set(ANGRY, (Object)isAngry);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getAttackType() == 1) {
            event.getController().setAnimation(this.THROW);
        } else if (this.getAttackType() == 2) {
            event.getController().setAnimation(this.RING);
        } else if (event.isMoving()) {
            event.getController().setAnimation(this.WALK);
        } else {
            event.getController().setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

