/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.hostile;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.HostileEntity;
import dev.xylonity.companions.common.entity.ai.antlion.wild.goal.WildAntlionBaseAttackGoal;
import dev.xylonity.companions.common.entity.ai.antlion.wild.goal.WildAntlionBaseLongAttackGoal;
import dev.xylonity.companions.common.entity.ai.antlion.wild.goal.WildAntlionNearestAttackableTarget;
import dev.xylonity.companions.common.entity.companion.AntlionEntity;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.companions.registry.CompanionsSounds;
import dev.xylonity.knightlib.api.TickScheduler;
import dev.xylonity.knightlib.registry.KnightLibParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class WildAntlionEntity
extends HostileEntity
implements PlayerRideable {
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation DIG_IN = RawAnimation.begin().thenPlay("dig");
    private final RawAnimation DIG_OUT = RawAnimation.begin().thenPlay("dig_out");
    private final RawAnimation DIG_IDLE = RawAnimation.begin().thenPlay("dig_idle");
    private final RawAnimation DIG_ATTACK = RawAnimation.begin().thenPlay("dig_attack");
    private final RawAnimation DIG_SHOOT = RawAnimation.begin().thenPlay("dig_attack2");
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.defineId(WildAntlionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.defineId(WildAntlionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final int ANIMATION_BASE_DIG_IN_TICKS = 55;
    private static final int ANIMATION_BASE_DIG_OUT_TICKS = 15;
    private static final int NO_TARGET_MAX_TICKS = 20;
    private int diginCounter = -1;
    private int digoutCounter = -1;
    private int noTargetCounter = -1;

    public WildAntlionEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.setNoMovement(this.isUnderground() || this.getState() == 1);
            if (this.getState() == 1 && this.diginCounter == -1) {
                ++this.diginCounter;
            }
            if (this.getState() == 2 && this.noTargetCounter == -1 && this.getTarget() == null) {
                ++this.noTargetCounter;
            } else if (this.getState() == 2 && this.noTargetCounter == -1 && this.getTarget() == null) {
                this.noTargetCounter = -1;
            }
            if (this.diginCounter != -1) {
                ++this.diginCounter;
            }
            if (this.digoutCounter != -1) {
                ++this.digoutCounter;
            }
            if (this.noTargetCounter != -1) {
                ++this.noTargetCounter;
            }
            if (this.diginCounter == 55) {
                this.cycleState();
                this.diginCounter = -1;
            }
            if (this.noTargetCounter == 20) {
                this.cycleState();
                this.noTargetCounter = -1;
                ++this.digoutCounter;
            }
            if (this.digoutCounter == 15) {
                this.cycleState();
                this.digoutCounter = -1;
            }
            if (this.diginCounter == 20 || this.diginCounter == 35 || this.digoutCounter == 5) {
                this.earthquake();
            }
        }
    }

    private void earthquake() {
        int radius = 2;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                int dist = Math.abs(x) + Math.abs(z);
                if (dist < 1 || dist > radius) continue;
                BlockPos blockPos = this.blockPosition().offset(x, -1, z);
                BlockState state = this.level().getBlockState(blockPos);
                if (state.isAir() || state.getBlock() == Blocks.BEDROCK) continue;
                if (dist == 1) {
                    this.spawnFallingBlock(blockPos, state, 0.18);
                    continue;
                }
                TickScheduler.scheduleServer((Level)this.level(), () -> this.spawnFallingBlock(blockPos, state, 0.2), (int)5);
            }
        }
    }

    private void spawnFallingBlock(BlockPos pos, BlockState state, double yDelay) {
        FallingBlockEntity block = new FallingBlockEntity(this.level(), (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, state);
        block.setDeltaMovement(0.0, yDelay, 0.0);
        this.level().addFreshEntity((Entity)block);
        this.level().removeBlock(pos, false);
    }

    public void cycleState() {
        switch (this.getState()) {
            case 0: {
                this.setState(1);
                break;
            }
            case 1: {
                this.setState(2);
                break;
            }
            case 2: {
                this.setState(3);
                break;
            }
            case 3: {
                this.setState(0);
            }
        }
    }

    public void setState(int state) {
        this.entityData.set(STATE, (Object)state);
    }

    public int getState() {
        return (Integer)this.entityData.get(STATE);
    }

    public boolean isUnderground() {
        return this.getState() == 2;
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new WildAntlionBaseAttackGoal(this, 20, 60));
        this.goalSelector.addGoal(1, (Goal)new WildAntlionBaseLongAttackGoal(this, 20, 60));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.43));
        this.targetSelector.addGoal(1, new WildAntlionNearestAttackableTarget<Player>(this, Player.class, true));
    }

    public static AttributeSupplier setAttributes() {
        return HostileEntity.createMobAttributes().add(Attributes.MAX_HEALTH, 50.0).add(Attributes.ATTACK_DAMAGE, 7.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.55f).add(Attributes.FOLLOW_RANGE, 35.0).build();
    }

    public int getAttackType() {
        return (Integer)this.entityData.get(ATTACK_TYPE);
    }

    public void setAttackType(int type) {
        this.entityData.set(ATTACK_TYPE, (Object)type);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ATTACK_TYPE, (Object)0);
        builder.define(STATE, (Object)0);
    }

    public void move(@NotNull MoverType pType, @NotNull Vec3 pPos) {
        super.move(pType, pPos);
        this.checkInsideBlocks();
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (!this.isEntityInFront((Entity)player) && player.getItemInHand(hand).getItem() == CompanionsItems.CRYSTALLIZED_BLOOD.get()) {
            if (this.level().isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (this.tameAntlion(player)) {
                this.tameParticles();
                this.discard();
            } else {
                this.failureParticles();
            }
        }
        return super.mobInteract(player, hand);
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return CompanionsSounds.ANTLION_DEATH.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return CompanionsSounds.ANTLION_HURT.get();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return CompanionsSounds.ANTLION_IDLE.get();
    }

    protected void playStepSound(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.playSound(CompanionsSounds.ANTLION_STEPS.get());
    }

    protected boolean isEntityInFront(Entity target) {
        Vec3 toTarget = new Vec3(target.getX(), this.getY(), target.getZ()).subtract(this.position()).normalize();
        double angle = Math.acos(this.getLookAngle().normalize().dot(toTarget)) * 57.29577951308232;
        return angle < 100.0;
    }

    private boolean tameAntlion(Player player) {
        if (this.level().random.nextFloat() < 0.55f) {
            AntlionEntity antlion = (AntlionEntity)CompanionsEntities.ANTLION.get().create(this.level());
            if (antlion != null) {
                antlion.moveTo(this.position());
                antlion.tameInteraction(player);
                this.level().addFreshEntity((Entity)antlion);
            }
            return true;
        }
        return false;
    }

    private void tameParticles() {
        for (int i = 0; i < 20; ++i) {
            double dx = (this.random.nextDouble() - 0.5) * 2.0;
            double dy = (this.random.nextDouble() - 0.5) * 2.0;
            double dz = (this.random.nextDouble() - 0.5) * 2.0;
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            if (level2.random.nextFloat() < 0.65f) {
                level2.sendParticles((ParticleOptions)ParticleTypes.POOF, this.getX(), this.getY() + (double)this.getBbHeight() * Math.random(), this.getZ(), 1, dx, dy, dz, 0.1);
            }
            if (!(level2.random.nextFloat() < 0.25f)) continue;
            level2.sendParticles((ParticleOptions)((SimpleParticleType)KnightLibParticles.STARSET.get()), this.getX(), this.getY() + (double)this.getBbHeight() * Math.random(), this.getZ(), 1, dx, dy, dz, 0.2);
        }
    }

    private void failureParticles() {
        for (int i = 0; i < 20; ++i) {
            double dx = (this.random.nextDouble() - 0.5) * 2.0;
            double dy = (this.random.nextDouble() - 0.5) * 2.0;
            double dz = (this.random.nextDouble() - 0.5) * 2.0;
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            if (!(level2.random.nextFloat() < 0.65f)) continue;
            level2.sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY() + (double)this.getBbHeight() * Math.random(), this.getZ(), 1, dx, dy, dz, 0.025);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getAttackType() == 1) {
            event.getController().setAnimation(this.DIG_ATTACK);
        } else if (this.getAttackType() == 2) {
            event.getController().setAnimation(this.DIG_SHOOT);
        } else if (this.getState() == 1) {
            event.getController().setAnimation(this.DIG_IN);
        } else if (this.getState() == 2) {
            event.getController().setAnimation(this.DIG_IDLE);
        } else if (this.getState() == 3) {
            event.getController().setAnimation(this.DIG_OUT);
        } else if (event.isMoving()) {
            event.getController().setAnimation(this.WALK);
        } else {
            event.getController().setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

