/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.entity.projectile.FrogLevitateProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import java.util.Random;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class AntlionSandProjectile
extends FrogLevitateProjectile {
    public AntlionSandProjectile(EntityType<? extends BaseProjectile> type, Level level) {
        super(type, level);
    }

    @Override
    public float getDefaultSpeed() {
        return 0.8225f;
    }

    @Override
    public float getDefaultLerp() {
        return 0.03f;
    }

    @Override
    public void spawnRibbon() {
        Companions.PROXY.spawnGenericRibbonTrail((Entity)this, this.level(), this.getX(), this.getY(), this.getZ(), 1.0f, 0.8509804f, 0.5647059f, 0.0f, 0.35f);
    }

    @Override
    public void spawnParticles() {
        if (this.tickCount % new Random().nextInt(2, 4) == 0) {
            this.level().addParticle((ParticleOptions)ParticleTypes.END_ROD, this.getX(), this.getY() + (double)this.getBbHeight() * 0.5, this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void onHitEntity(@NotNull EntityHitResult pResult) {
        Level level;
        for (LivingEntity e : this.level().getEntitiesOfClass(LivingEntity.class, new AABB(this.blockPosition()).inflate(3.0))) {
            if (Util.areEntitiesLinked((Entity)e, (Entity)this)) continue;
            e.hurt(this.damageSources().magic(), (float)CompanionsConfig.ANTLION_SOLDIER_PROJECTILE_DAMAGE);
        }
        if (!this.level().isClientSide && (level = this.level()) instanceof ServerLevel) {
            ServerLevel sv = (ServerLevel)level;
            sv.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SAND.defaultBlockState()), this.position().x, this.position().y, this.position().z, 10, 0.25, 0.25, 0.25, 0.0225);
        }
        this.remove(Entity.RemovalReason.KILLED);
    }
}

