/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.common.entity.projectile.SmallIceShardProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsEntities;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BigIceShardProjectile
extends AbstractArrow
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final int LIFETIME = 25;
    private static final double RAY_DISTANCE = 64.0;
    private static final double SMALL_SHARD_SPEED = 0.4;
    private static final RawAnimation APPEAR = RawAnimation.begin().thenPlay("appear");
    private LivingEntity target;

    public BigIceShardProjectile(EntityType<? extends AbstractArrow> type, Level level) {
        super(type, level);
        double minElevation = Math.toRadians(30.0);
        double elevation = minElevation + this.random.nextDouble() * (Math.toRadians(90.0) - minElevation);
        double t = this.random.nextDouble() * Math.PI * 2.0;
        double dx = Math.cos(elevation) * Math.cos(t);
        double dy = Math.sin(elevation);
        double dz = Math.cos(elevation) * Math.sin(t);
        this.setDeltaMovement(new Vec3(dx, dy, dz).normalize().scale(4.0));
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    protected boolean canHitEntity(@NotNull Entity entity) {
        if (Util.areEntitiesLinked(entity, (Entity)this)) {
            return false;
        }
        return super.canHitEntity(entity);
    }

    public void setTarget(@Nullable LivingEntity tgt) {
        this.target = tgt;
    }

    @Nullable
    public LivingEntity getTarget() {
        return this.target;
    }

    public void tick() {
        super.tick();
        Entity owner = this.getOwner();
        if (owner != null) {
            this.setNoGravity(true);
            if (this.tickCount < 25) {
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95));
            }
            if (this.tickCount == 25) {
                if (this.level().isClientSide) {
                    this.spawnHitParticles();
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)3);
                    this.playSound(SoundEvents.AMETHYST_BLOCK_RESONATE);
                }
                for (int i = 0; i < 5; ++i) {
                    SmallIceShardProjectile shard = (SmallIceShardProjectile)CompanionsEntities.SMALL_ICE_SHARD_PROJECTILE.get().create(this.level());
                    if (shard == null) continue;
                    shard.moveTo(this.getX(), this.getY(), this.getZ());
                    shard.setOwner(owner);
                    LivingEntity target1 = this.getTarget();
                    if (target1 == null && owner instanceof LivingEntity) {
                        LivingEntity livingOwner = (LivingEntity)owner;
                        target1 = BigIceShardProjectile.findEntityInCrosshair(livingOwner);
                    }
                    if (target1 != null) {
                        shard.setTarget(target1);
                    } else {
                        shard.setFollowOwnerLook(true);
                        shard.shootTowards(BigIceShardProjectile.genRandomShardDir(owner instanceof LivingEntity ? owner.getLookAngle() : this.getDeltaMovement().normalize()), 0.4);
                    }
                    this.level().addFreshEntity((Entity)shard);
                }
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    @Nullable
    private static LivingEntity findEntityInCrosshair(LivingEntity player) {
        AABB bb = player.getBoundingBox().expandTowards(player.getLookAngle().scale(64.0)).inflate(1.0);
        EntityHitResult hit = ProjectileUtil.getEntityHitResult((Level)player.level(), (Entity)player, (Vec3)player.getEyePosition(), (Vec3)player.getEyePosition().add(player.getLookAngle().scale(64.0)), (AABB)bb, e -> e instanceof LivingEntity && e != player);
        return hit != null ? (LivingEntity)hit.getEntity() : null;
    }

    private static Vec3 genRandomShardDir(Vec3 dir) {
        Random random = new Random();
        Vec3 forward = dir.normalize();
        Vec3 up = Math.abs(forward.dot(new Vec3(0.0, 1.0, 0.0))) > 0.99 ? new Vec3(1.0, 0.0, 0.0) : new Vec3(0.0, 1.0, 0.0);
        Vec3 right = forward.cross(up).normalize();
        up = right.cross(forward).normalize();
        double maxRad = Math.toRadians(8.0);
        double ct = random.nextDouble() * (1.0 - Math.cos(maxRad)) + Math.cos(maxRad);
        double st = Math.sqrt(1.0 - ct * ct);
        double ph = random.nextDouble() * Math.PI * 2.0;
        return forward.scale(ct).add(right.scale(st * Math.cos(ph))).add(up.scale(st * Math.sin(ph))).normalize();
    }

    private void spawnHitParticles() {
        for (int i = 0; i < 10; ++i) {
            double dx = (this.level().getRandom().nextDouble() - 0.5) * 0.1;
            double dy = (this.level().getRandom().nextDouble() - 0.5) * 0.1;
            double dz = (this.level().getRandom().nextDouble() - 0.5) * 0.1;
            this.level().addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, this.getX(), this.getY(), this.getZ(), dx, dy, dz);
        }
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 3) {
            this.spawnHitParticles();
        } else {
            super.handleEntityEvent(pId);
        }
    }

    @NotNull
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.AMETHYST_BLOCK_HIT;
    }

    protected boolean tryPickup(@NotNull Player pPlayer) {
        return false;
    }

    @NotNull
    protected ItemStack getPickupItem() {
        return ItemStack.EMPTY;
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    public void playerTouch(@NotNull Player pPlayer) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.tickCount <= 8) {
            event.getController().setAnimation(APPEAR);
        }
        return PlayState.CONTINUE;
    }
}

