/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class BlackHoleProjectile
extends BaseProjectile {
    private static final RawAnimation DISAPPEAR = RawAnimation.begin().thenPlay("disappear");
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private static final EntityDataAccessor<Boolean> IS_LOCKED = SynchedEntityData.defineId(BlackHoleProjectile.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> TICKCOUNT = SynchedEntityData.defineId(BlackHoleProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final double ATTRACT_RADIUS = CompanionsConfig.BLACK_HOLE_ATTRACTION_RADIUS;
    private static final float GRAVITY = 0.03f;

    public BlackHoleProjectile(EntityType<? extends BaseProjectile> type, Level level) {
        super(type, level);
        this.noPhysics = false;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_LOCKED, (Object)false);
        builder.define(TICKCOUNT, (Object)0);
    }

    public boolean isLocked() {
        return (Boolean)this.entityData.get(IS_LOCKED);
    }

    public void setLocked(boolean locked) {
        this.entityData.set(IS_LOCKED, (Object)locked);
    }

    public int getTickCount() {
        return (Integer)this.entityData.get(TICKCOUNT);
    }

    public void setTickCount(int tickCount) {
        this.entityData.set(TICKCOUNT, (Object)tickCount);
    }

    private void updateRotation(Vec3 vel) {
        double horizontalMag = vel.horizontalDistance();
        float newYaw = (float)(Mth.atan2((double)vel.x, (double)vel.z) * 57.29577951308232);
        float newPitch = (float)(Mth.atan2((double)vel.y, (double)horizontalMag) * 57.29577951308232);
        this.setYRot(BlackHoleProjectile.lerpRotation((float)this.getYRot(), (float)newYaw));
        this.setXRot(BlackHoleProjectile.lerpRotation((float)this.getXRot(), (float)newPitch));
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide) {
            this.setTickCount(this.tickCount);
        }
        super.tick();
        if (this.getTickCount() == 20) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), CompanionsSounds.SPELL_RELEASE_SPEARS.get(), this.getSoundSource(), 1.5f, 1.0f);
        }
        Random random = new Random();
        if ((double)random.nextFloat() < 0.44 && this.getTickCount() < this.getLifetime() - 20) {
            for (int i = 0; i < 1; ++i) {
                Level level = this.level();
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel level2 = (ServerLevel)level;
                double x = (Math.random() - 0.5) * 0.5;
                double z = (Math.random() - 0.5) * 0.5;
                level2.sendParticles((ParticleOptions)CompanionsParticles.BLACK_HOLE_STAR.get(), this.getX() + x, this.getY() - 0.2, this.getZ() + z, 1, (Math.random() - 0.5) * 0.1, 0.0, (Math.random() - 0.5) * 0.1, 0.2);
            }
        }
        if (this.getTickCount() >= this.getLifetime()) {
            this.discard();
            return;
        }
        if (this.isLocked()) {
            if (this.level().isClientSide) {
                for (Player player : this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(30.0))) {
                    Companions.PROXY.shakePlayerCamera(player, 5, 0.1f, 0.1f, 0.1f, 10);
                }
            }
            this.setDeltaMovement(Vec3.ZERO);
            this.attractNearbyEntities();
            return;
        }
        if (!this.level().isClientSide && this.tickCount >= 20 && !this.isLocked()) {
            this.setLocked(true);
        }
        Vec3 oldPos = this.position();
        Vec3 vel = this.getDeltaMovement();
        if (!this.noPhysics) {
            vel = vel.add(0.0, (double)-0.03f, 0.0);
        }
        vel = vel.scale(0.99);
        BlockHitResult blockHit = this.level().clip(new ClipContext(oldPos, oldPos.add(vel), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (blockHit.getType() == HitResult.Type.BLOCK) {
            Vec3 hitPos = blockHit.getLocation();
            this.setPos(hitPos.x, hitPos.y, hitPos.z);
            this.setDeltaMovement(Vec3.ZERO);
            this.setLocked(true);
        } else {
            this.setDeltaMovement(vel);
            this.move(MoverType.SELF, vel);
            this.updateRotation(vel);
            if (this.onGround()) {
                this.setLocked(true);
                this.setDeltaMovement(Vec3.ZERO);
            }
        }
        this.attractNearbyEntities();
    }

    private void attractNearbyEntities() {
        List nearby = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(ATTRACT_RADIUS), e -> !Util.areEntitiesLinked((Entity)e, (Entity)this));
        for (LivingEntity ent : nearby) {
            Vec3 toCenter = new Vec3(this.getX() - ent.getX(), this.getY() - ent.getY(), this.getZ() - ent.getZ());
            double distance = toCenter.length();
            if (distance < 0.05) continue;
            toCenter = toCenter.normalize();
            double linear = (ATTRACT_RADIUS - distance) / ATTRACT_RADIUS;
            if (linear < 0.0) {
                linear = 0.0;
            }
            Vec3 desiredVel = toCenter.scale(Math.pow(linear, 2.0) * CompanionsConfig.BLACK_HOLE_ATTRACTION_SPEED);
            Vec3 currentVel = ent.getDeltaMovement();
            Vec3 newVel = currentVel.lerp(desiredVel, 0.15);
            ent.setDeltaMovement(newVel);
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "extraController", this::extraPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", this::predicate));
    }

    @Override
    protected int baseLifetime() {
        return 100;
    }

    private <T extends GeoAnimatable> PlayState extraPredicate(AnimationState<T> event) {
        if (this.getTickCount() >= this.getLifetime() - 7) {
            event.getController().setAnimation(DISAPPEAR);
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.getController().setAnimation(IDLE);
        return PlayState.CONTINUE;
    }
}

