/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.registry.CompanionsEffects;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FireMarkProjectile
extends Projectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");

    public FireMarkProjectile(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.noPhysics = true;
    }

    public void tick() {
        super.tick();
        if (this.getOwner() == null) {
            this.remove(Entity.RemovalReason.KILLED);
            return;
        }
        if (!this.level().isClientSide && !((LivingEntity)this.getOwner()).hasEffect(CompanionsEffects.FIRE_MARK)) {
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (!this.getOwner().isRemoved()) {
            Vec3 targetPos = new Vec3(this.getOwner().getX(), this.getOwner().getY() + (double)this.getOwner().getBbHeight() + 0.5, this.getOwner().getZ());
            Vec3 offset = targetPos.subtract(this.position());
            Vec3 velocity = this.getDeltaMovement();
            double K = 0.06;
            double C = 2.0 * Math.sqrt(K);
            Vec3 accel = offset.scale(K).subtract(velocity.scale(C));
            velocity = velocity.add(accel);
            this.setDeltaMovement(velocity);
            this.move(MoverType.SELF, velocity);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.getController().setAnimation(this.IDLE);
        return PlayState.CONTINUE;
    }
}

