/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HolinessNaginataProjectile
extends ThrownTrident
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Quaternionf prevRot = new Quaternionf();
    private final Quaternionf currentRot = new Quaternionf();
    protected boolean dealtDamage;
    protected int timeToDespawn;

    public HolinessNaginataProjectile(EntityType<? extends ThrownTrident> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
        if (!this.level().isClientSide) {
            this.timeToDespawn = new Random().nextInt(120, 300);
        }
    }

    protected boolean canHitEntity(@NotNull Entity entity) {
        if (Util.areEntitiesLinked((Entity)this, entity)) {
            return false;
        }
        return super.canHitEntity(entity);
    }

    public void tickDespawn() {
        if (this.inGroundTime >= this.timeToDespawn) {
            this.discard();
        }
    }

    protected boolean tryPickup(@NotNull Player pPlayer) {
        return false;
    }

    @NotNull
    public AABB getBoundingBoxForCulling() {
        return super.getBoundingBoxForCulling().inflate(10.0);
    }

    public void refreshOrientation() {
        Vec3 v = this.getDeltaMovement();
        if (v.lengthSqr() < 1.0E-7) {
            return;
        }
        float yaw = (float)Math.atan2(v.x, v.z);
        float pitch = (float)Math.atan2(v.y, Math.hypot(v.x, v.z));
        this.setYRot(yaw * 57.295776f);
        this.setXRot(pitch * 57.295776f);
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        Quaternionf quaternionf = new Quaternionf().rotateY(yaw + (float)Math.PI).rotateX(pitch);
        this.prevRot.set((Quaternionfc)this.currentRot);
        this.currentRot.set((Quaternionfc)quaternionf);
    }

    protected void onHitBlock(@NotNull BlockHitResult pResult) {
        super.onHitBlock(pResult);
        this.doShake();
    }

    protected void doShake() {
        if (this.level().isClientSide) {
            for (Player player : this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(30.0))) {
                Companions.PROXY.shakePlayerCamera(player, 5, 0.1f, 0.1f, 0.1f, 10);
            }
        }
    }

    public void tick() {
        if (this.tickCount < 2) {
            this.setInvisible(true);
        } else if (this.tickCount < 5) {
            this.setInvisible(false);
        }
        if (this.getDeltaMovement().lengthSqr() > 1.0E-7) {
            this.refreshOrientation();
        }
        super.tick();
    }

    @Nullable
    protected EntityHitResult findHitEntity(@NotNull Vec3 pStartVec, @NotNull Vec3 pEndVec) {
        return this.dealtDamage ? null : super.findHitEntity(pStartVec, pEndVec);
    }

    protected void onHitEntity(EntityHitResult pResult) {
        Entity entity = pResult.getEntity();
        Entity owner = this.getOwner();
        DamageSource damageSource = this.damageSources().trident((Entity)this, (Entity)(owner == null ? this : owner));
        this.dealtDamage = true;
        entity.hurt(damageSource, (float)CompanionsConfig.NAGINATA_DAMAGE);
        this.playSound(SoundEvents.TRIDENT_HIT, 5.0f, 1.0f);
    }

    public Quaternionf getPrevRotation() {
        return this.prevRot;
    }

    public Quaternionf getCurrentRotation() {
        return this.currentRot;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }
}

