/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.util.Util;
import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class LaserRingProjectile
extends BaseProjectile {
    public LaserRingProjectile(EntityType<? extends BaseProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void tick() {
        double px = this.getX();
        double py = this.getY();
        double pz = this.getZ();
        super.tick();
        this.setPos(px, py, pz);
        if (this.tickCount % 2 == 0 && !this.level().isClientSide) {
            int radius = this.tickCount / 2 + 1;
            double inner = radius - 1;
            double outer = radius + 1;
            AABB box = new AABB(px - outer, py - 1.0, pz - outer, px + outer, py + 1.0, pz + outer);
            for (LivingEntity e : this.level().getEntitiesOfClass(LivingEntity.class, box)) {
                Entity entity;
                double dz;
                double dx = e.getX() - px;
                double dist = Math.sqrt(dx * dx + (dz = e.getZ() - pz) * dz);
                if (!(dist > inner) || !(dist <= outer) || this.getOwner() == null || Util.areEntitiesLinked(this.getOwner(), (Entity)e)) continue;
                if (this.getOwner() != null && (entity = this.getOwner()) instanceof LivingEntity) {
                    LivingEntity owner = (LivingEntity)entity;
                    owner.doHurtTarget((Entity)e);
                }
                e.setRemainingFireTicks(this.level().getRandom().nextInt(1, 15) * 20);
            }
        }
        if (this.level().isClientSide) {
            Random random = new Random();
            if (random.nextFloat() < 0.3f) {
                Companions.PROXY.spawnLaserRingElectricArc((Entity)this, this.level(), 7.0f);
            }
        }
    }

    @Override
    protected int baseLifetime() {
        return 20;
    }
}

