/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.entity.CompanionSummonEntity;
import dev.xylonity.companions.common.entity.summon.BubbleFrogEntity;
import dev.xylonity.companions.common.entity.summon.EmberPoleEntity;
import dev.xylonity.companions.common.entity.summon.EnderFrogEntity;
import dev.xylonity.companions.common.entity.summon.FireworkToadEntity;
import dev.xylonity.companions.common.entity.summon.NetherBullfrogEntity;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class ScrollProjectile
extends BaseProjectile {
    private final RawAnimation SPAWN = RawAnimation.begin().thenPlay("spawn");
    private static final EntityDataAccessor<Integer> ENTITY_TO_SPAWN = SynchedEntityData.defineId(ScrollProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(ScrollProjectile.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Optional<UUID>> SECOND_OWNER_UUID = SynchedEntityData.defineId(ScrollProjectile.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public static final int WHEN_TO_SUMMON = 30;

    public ScrollProjectile(EntityType<? extends BaseProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.tickCount == 30 && !this.level().isClientSide) {
            this.spawnParticles();
            CompanionSummonEntity e = this.getEntityToSpawn();
            if (e != null && this.getOwnerUUID() != null) {
                e.setOwnerUUID(this.getOwnerUUID());
                e.setSecondOwnerUUID(this.getSecondOwnerUUID());
                e.setTame(true, false);
                e.moveTo(this.position());
                this.level().addFreshEntity((Entity)e);
            }
            this.playSound(CompanionsSounds.SCROLL_SOUND.get(), 0.75f, 1.0f);
        }
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(OWNER_UUID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.entityData.set(OWNER_UUID, Optional.ofNullable(pUuid));
    }

    public UUID getSecondOwnerUUID() {
        return ((Optional)this.entityData.get(SECOND_OWNER_UUID)).orElse(null);
    }

    public void setSecondOwnerUUID(@Nullable UUID pUuid) {
        this.entityData.set(SECOND_OWNER_UUID, Optional.ofNullable(pUuid));
    }

    private CompanionSummonEntity getEntityToSpawn() {
        return switch ((Integer)this.entityData.get(ENTITY_TO_SPAWN)) {
            case 1 -> (FireworkToadEntity)CompanionsEntities.FIREWORK_TOAD.get().create(this.level());
            case 2 -> (NetherBullfrogEntity)CompanionsEntities.NETHER_BULLFROG.get().create(this.level());
            case 3 -> (EnderFrogEntity)CompanionsEntities.ENDER_FROG.get().create(this.level());
            case 4 -> (EmberPoleEntity)CompanionsEntities.EMBER_POLE.get().create(this.level());
            case 5 -> (BubbleFrogEntity)CompanionsEntities.BUBBLE_FROG.get().create(this.level());
            default -> null;
        };
    }

    private void spawnParticles() {
        for (int i = 0; i < 10; ++i) {
            double dx = (this.level().random.nextDouble() - 0.5) * 0.75;
            double dy = (this.level().random.nextDouble() - 0.5) * 0.75;
            double dz = (this.level().random.nextDouble() - 0.5) * 0.75;
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            level2.sendParticles((ParticleOptions)ParticleTypes.POOF, this.position().x, this.position().y + (double)this.getBbHeight(), this.position().z, 1, dx, dy, dz, 0.1);
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ENTITY_TO_SPAWN, (Object)0);
        builder.define(OWNER_UUID, Optional.empty());
        builder.define(SECOND_OWNER_UUID, Optional.empty());
    }

    public void setEntityToSpawn(int id) {
        this.entityData.set(ENTITY_TO_SPAWN, (Object)id);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.setAnimation(this.SPAWN);
        return PlayState.CONTINUE;
    }

    @Override
    protected int baseLifetime() {
        return 47;
    }
}

