/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.entity.ShadeEntity;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsParticles;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class ShadeSwordImpactProjectile
extends BaseProjectile {
    private final RawAnimation SHOOT = RawAnimation.begin().thenPlay("shoot");
    private static final EntityDataAccessor<Direction> DIRECTION = SynchedEntityData.defineId(ShadeSwordImpactProjectile.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);

    public ShadeSwordImpactProjectile(EntityType<? extends ShadeSwordImpactProjectile> type, Level level) {
        super(type, level);
        this.setNoGravity(true);
        this.noPhysics = true;
        this.noCulling = true;
    }

    @Override
    protected int baseLifetime() {
        return 35;
    }

    public boolean shouldRenderAtSqrDistance(double pDistance) {
        return pDistance < 1024.0;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.tickCount % 8 == 0) {
            double dx = (this.random.nextDouble() - 0.5) * (double)this.getBbWidth();
            double dy = (this.random.nextDouble() - 0.5) * (double)this.getBbWidth();
            double dz = (this.random.nextDouble() - 0.5) * (double)this.getBbWidth();
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                level2.sendParticles((ParticleOptions)CompanionsParticles.SHADE_SUMMON.get(), this.getX(), this.getY() + (double)this.getBbHeight() * Math.random(), this.getZ(), 1, dx, dy, dz, 0.1);
            }
        }
        Vec3 v = this.getDeltaMovement();
        this.setPos(this.getX() + v.x, this.getY() + v.y, this.getZ() + v.z);
        if (!this.level().isClientSide) {
            for (LivingEntity victim : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox(), e -> !Util.areEntitiesLinked((Entity)e, (Entity)this))) {
                Entity entity;
                if (this.getOwner() == null || !((entity = this.getOwner()) instanceof ShadeEntity)) continue;
                ShadeEntity entity2 = (ShadeEntity)entity;
                entity2.doHurtTarget((Entity)victim);
            }
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DIRECTION, (Object)Direction.NORTH);
    }

    @NotNull
    public Direction getDirection() {
        return (Direction)this.entityData.get(DIRECTION);
    }

    public void setDirection(Direction direction) {
        this.entityData.set(DIRECTION, (Object)direction);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.getController().setAnimation(this.SHOOT);
        return PlayState.CONTINUE;
    }
}

