/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SmallIceShardProjectile
extends AbstractArrow
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final int PHASE_1_DURATION = 20;
    private static final double PHASE_1_FRICTION = 0.95;
    private static final double PHASE_2_FRICTION = 0.88;
    private static final double PHASE_2_ACCELERATION = 0.04;
    private static final int LIFETIME = 200;
    private LivingEntity target;
    private boolean followOwnerLook = false;
    private final Quaternionf prevRotation = new Quaternionf();
    private final Quaternionf currentRotation = new Quaternionf();

    public SmallIceShardProjectile(EntityType<? extends AbstractArrow> type, Level level) {
        super(type, level);
        Vec3 randomDir = new Vec3(this.random.nextDouble() * 2.0 - 1.0, this.random.nextDouble() * 2.0 - 1.0, this.random.nextDouble() * 2.0 - 1.0).normalize();
        this.setDeltaMovement(randomDir.scale(0.2));
        this.setNoGravity(true);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    public void setTarget(@Nullable LivingEntity target) {
        this.target = target;
    }

    @Nullable
    public LivingEntity getTarget() {
        return this.target;
    }

    protected boolean canHitEntity(@NotNull Entity entity) {
        if (Util.areEntitiesLinked(entity, (Entity)this)) {
            return false;
        }
        return super.canHitEntity(entity);
    }

    public void tick() {
        Entity targetPos;
        super.tick();
        if (this.target != null) {
            if (this.tickCount < 20) {
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95));
            } else {
                targetPos = new Vec3(this.target.getX(), this.target.getY() + (double)this.target.getBbHeight() * 0.7, this.target.getZ());
                Vec3 diff = targetPos.subtract(this.position());
                Vec3 newVel = this.getDeltaMovement().scale(0.88).add(diff.normalize().scale(0.04));
                this.setDeltaMovement(newVel);
            }
        } else if (this.followOwnerLook && (targetPos = this.getOwner()) instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)targetPos;
            if (this.tickCount < 20) {
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95));
            } else {
                targetPos = owner.getLookAngle().normalize();
                Vec3 newVel = this.getDeltaMovement().scale(0.88).add(targetPos.scale(0.04));
                this.setDeltaMovement(newVel);
            }
        }
        this.updateRotations();
        if (this.tickCount == 200) {
            if (this.level().isClientSide) {
                this.spawnHitParticles();
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)3);
                this.playSound(SoundEvents.AMETHYST_BLOCK_RESONATE);
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (this.level().isClientSide && (this.tickCount % 40 == 0 || this.tickCount == 1)) {
            float r = (float)(190 + this.level().random.nextInt(30)) / 255.0f;
            float g = (float)(240 + this.level().random.nextInt(10)) / 255.0f;
            float b = (float)(247 + this.level().random.nextInt(5)) / 255.0f;
            Companions.PROXY.spawnBaseProjectileTrail((Entity)this, 0.0f, this.getBbHeight() * 0.5f, r, g, b);
        }
    }

    private void updateRotations() {
        Vec3 vel = this.getDeltaMovement();
        if (vel.lengthSqr() <= 1.0E-7) {
            return;
        }
        this.prevRotation.set((Quaternionfc)this.currentRotation);
        Vector3f velVec = new Vector3f((float)vel.x, (float)vel.y, (float)vel.z).normalize();
        Vector3f forward = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f axis = forward.cross((Vector3fc)velVec);
        if (axis.length() < 1.0E-4f) {
            axis.set(0.0f, 1.0f, 0.0f);
        } else {
            axis.normalize();
        }
        float dot = Math.max(-1.0f, Math.min(1.0f, forward.dot((Vector3fc)velVec)));
        Quaternionf targetRot = new Quaternionf().fromAxisAngleRad((Vector3fc)axis, (float)Math.acos(dot));
        if (this.tickCount < 20) {
            this.currentRotation.set((Quaternionfc)targetRot);
        } else {
            this.currentRotation.slerp((Quaternionfc)targetRot, 0.5f);
        }
    }

    protected void onHit(@NotNull HitResult pResult) {
        if (pResult.getType().equals((Object)HitResult.Type.ENTITY)) {
            TamableAnimal t;
            Entity target = ((EntityHitResult)pResult).getEntity();
            if (target.equals((Object)this.getOwner()) || target instanceof TamableAnimal && (t = (TamableAnimal)target).getOwner() != null && t.getOwner().equals((Object)this.getOwner())) {
                return;
            }
            target.hurt(this.damageSources().magic(), (float)CompanionsConfig.SMALL_ICE_SHARD_DAMAGE);
            target.setTicksFrozen(target.getTicksFrozen() + CompanionsConfig.SMALL_ICE_SHARD_FREEZE_TICKS);
        }
        if (this.level().isClientSide) {
            this.spawnHitParticles();
        } else {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.playSound(SoundEvents.AMETHYST_BLOCK_HIT);
        }
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 3) {
            this.spawnHitParticles();
        } else {
            super.handleEntityEvent(pId);
        }
    }

    public void setFollowOwnerLook(boolean ownerLook) {
        this.followOwnerLook = ownerLook;
    }

    public void shootTowards(Vec3 dir, double speed) {
        this.setDeltaMovement(dir.normalize().scale(speed));
    }

    public Quaternionf getPrevRotation() {
        return this.prevRotation;
    }

    public Quaternionf getCurrentRotation() {
        return this.currentRotation;
    }

    private void spawnHitParticles() {
        for (int i = 0; i < 5; ++i) {
            double dx = (this.level().getRandom().nextDouble() - 0.5) * 0.1;
            double dy = (this.level().getRandom().nextDouble() - 0.5) * 0.1;
            double dz = (this.level().getRandom().nextDouble() - 0.5) * 0.1;
            this.level().addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, this.getX(), this.getY(), this.getZ(), dx, dy, dz);
            if (i % 2 != 0) continue;
            this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Items.ICE)), this.getX(), this.getY() + (double)this.getBbHeight() * 0.5, this.getZ(), dx, dy, dz);
        }
    }

    protected boolean tryPickup(@NotNull Player p) {
        return false;
    }

    @NotNull
    protected ItemStack getPickupItem() {
        return ItemStack.EMPTY;
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    public void playerTouch(@NotNull Player p) {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar r) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

