/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile.trigger;

import dev.xylonity.companions.common.entity.hostile.SacredPontiffEntity;
import dev.xylonity.companions.common.entity.projectile.FireRayPieceProjectile;
import dev.xylonity.companions.registry.CompanionsEntities;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtil;

public class FireRayBeamEntity
extends Entity
implements GeoAnimatable {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Float> ORIGIN_X = SynchedEntityData.defineId(FireRayBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ORIGIN_Y = SynchedEntityData.defineId(FireRayBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ORIGIN_Z = SynchedEntityData.defineId(FireRayBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> START_YAW = SynchedEntityData.defineId(FireRayBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> ROT_TICKS = SynchedEntityData.defineId(FireRayBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> MAX_PIECES = SynchedEntityData.defineId(FireRayBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> SEPARATION = SynchedEntityData.defineId(FireRayBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> START_PITCH = SynchedEntityData.defineId(FireRayBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private int age;
    private UUID[] pieceUUIDs;

    public FireRayBeamEntity(EntityType<? extends FireRayBeamEntity> type, Level level) {
        super(type, level);
        this.noPhysics = true;
        this.pieceUUIDs = new UUID[0];
    }

    public FireRayBeamEntity(ServerLevel lvl, Vec3 origin, float yaw0, float pitch0, int rotTicks, int maxPieces, float sep, SacredPontiffEntity entity) {
        this(CompanionsEntities.FIRE_RAY_BEAM_ENTITY.get(), (Level)lvl);
        this.setPos(origin.x, origin.y, origin.z);
        this.entityData.set(ORIGIN_X, (Object)Float.valueOf((float)origin.x));
        this.entityData.set(ORIGIN_Y, (Object)Float.valueOf((float)origin.y));
        this.entityData.set(ORIGIN_Z, (Object)Float.valueOf((float)origin.z));
        this.entityData.set(START_YAW, (Object)Float.valueOf(yaw0));
        this.entityData.set(START_PITCH, (Object)Float.valueOf(pitch0));
        this.entityData.set(ROT_TICKS, (Object)rotTicks);
        this.entityData.set(MAX_PIECES, (Object)maxPieces);
        this.entityData.set(SEPARATION, (Object)Float.valueOf(sep));
        this.pieceUUIDs = new UUID[maxPieces];
        this.spawnPieces(lvl, entity);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ORIGIN_X, (Object)Float.valueOf(0.0f));
        builder.define(ORIGIN_Y, (Object)Float.valueOf(0.0f));
        builder.define(ORIGIN_Z, (Object)Float.valueOf(0.0f));
        builder.define(START_YAW, (Object)Float.valueOf(0.0f));
        builder.define(ROT_TICKS, (Object)0);
        builder.define(MAX_PIECES, (Object)0);
        builder.define(SEPARATION, (Object)Float.valueOf(0.0f));
        builder.define(START_PITCH, (Object)Float.valueOf(0.0f));
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag tag) {
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag tag) {
    }

    private void spawnPieces(ServerLevel level, SacredPontiffEntity entity) {
        int maxPieces = (Integer)this.entityData.get(MAX_PIECES);
        for (int i = 0; i < maxPieces; ++i) {
            FireRayPieceProjectile piece = (FireRayPieceProjectile)CompanionsEntities.FIRE_RAY_PIECE_PROJECTILE.get().create((Level)level);
            if (piece == null) continue;
            piece.initAsChild(this, i);
            piece.setOwner((Entity)entity);
            level.addFreshEntity((Entity)piece);
            this.pieceUUIDs[i] = piece.getUUID();
        }
    }

    public boolean shouldBeSaved() {
        return false;
    }

    public boolean save(CompoundTag compound) {
        return false;
    }

    public boolean saveAsPassenger(CompoundTag compound) {
        return false;
    }

    public void tick() {
        Level level;
        super.tick();
        if (this.level().isClientSide) {
            return;
        }
        if (this.tickCount % 5 == 0 && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.FLASH, this.getX(), this.getY(), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        float eased = 0.5f * (1.0f - Mth.cos((float)((float)this.age / (float)((Integer)this.entityData.get(ROT_TICKS)).intValue() * (float)Math.PI)));
        double yaw = Math.toRadians((((Float)this.entityData.get(START_YAW)).floatValue() + eased * 720.0f) % 360.0f);
        double pitch = Math.toRadians(((Float)this.entityData.get(START_PITCH)).floatValue());
        Vec3 direction = new Vec3(Math.cos(pitch) * Math.cos(yaw), Math.sin(pitch), Math.cos(pitch) * Math.sin(yaw));
        Vec3 origin = new Vec3((double)((Float)this.entityData.get(ORIGIN_X)).floatValue(), (double)((Float)this.entityData.get(ORIGIN_Y)).floatValue(), (double)((Float)this.entityData.get(ORIGIN_Z)).floatValue());
        boolean blocked = false;
        for (int i = 0; i < this.pieceUUIDs.length; ++i) {
            boolean solid;
            Entity e = ((ServerLevel)this.level()).getEntity(this.pieceUUIDs[i]);
            if (!(e instanceof FireRayPieceProjectile)) continue;
            FireRayPieceProjectile piece = (FireRayPieceProjectile)e;
            Vec3 pos = origin.add(direction.scale((double)((float)i * ((Float)this.entityData.get(SEPARATION)).floatValue())));
            piece.syncPosition(pos);
            boolean bl = solid = !this.level().getBlockState(BlockPos.containing((Position)pos)).getCollisionShape((BlockGetter)this.level(), BlockPos.containing((Position)pos)).isEmpty();
            if (!blocked && solid) {
                blocked = true;
                piece.setInvisible(false);
            } else if (blocked) {
                piece.setInvisible(true);
            } else {
                piece.setInvisible(false);
            }
            if (i != 0) continue;
            piece.setInvisible(true);
        }
        if (++this.age >= 135) {
            this.discard();
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object o) {
        return RenderUtil.getCurrentTick();
    }
}

