/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.summon;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.CompanionSummonEntity;
import dev.xylonity.companions.common.entity.ai.cornelius.summon.goal.EmberPoleApproachTargetGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionSummonFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsSummonHurtTargetGoal;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class EmberPoleEntity
extends CompanionSummonEntity {
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation EXPLODE = RawAnimation.begin().thenPlay("explode");
    private static final EntityDataAccessor<Boolean> IS_EXPLODING = SynchedEntityData.defineId(EmberPoleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final int ANIMATION_EXPLODE_TICKS = 55;
    private int explodeCounter = -1;

    public EmberPoleEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    public static AttributeSupplier setAttributes() {
        return TamableAnimal.createMobAttributes().add(Attributes.MAX_HEALTH, 7.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.55f).add(Attributes.FOLLOW_RANGE, 35.0).build();
    }

    public void setIsExploding(boolean exploding) {
        this.entityData.set(IS_EXPLODING, (Object)exploding);
    }

    public boolean isExploding() {
        return (Boolean)this.entityData.get(IS_EXPLODING);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_EXPLODING, (Object)false);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.getTarget() != null && this.distanceToSqr((Entity)this.getTarget()) < 9.0) {
                this.setIsExploding(true);
            }
            if (this.isExploding() && this.explodeCounter == -1) {
                this.explodeCounter = 0;
            }
            this.setNoMovement(this.isExploding());
            this.explode();
            if (this.explodeCounter >= 0) {
                ++this.explodeCounter;
                if (this.explodeCounter == 2) {
                    this.playSound(SoundEvents.DRAGON_FIREBALL_EXPLODE, 0.75f, 1.0f);
                } else if (this.explodeCounter >= 55) {
                    this.discard();
                }
            }
        }
    }

    private void explode() {
        if (this.explodeCounter == 3) {
            for (int i = 0; i < 20; ++i) {
                double dx = (this.random.nextDouble() - 0.5) * 2.0;
                double dy = (this.random.nextDouble() - 0.5) * 2.0;
                double dz = (this.random.nextDouble() - 0.5) * 2.0;
                Level level = this.level();
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel level2 = (ServerLevel)level;
                if (level2.random.nextFloat() < 0.7f) {
                    level2.sendParticles((ParticleOptions)ParticleTypes.POOF, this.getX(), this.getY() + (double)this.getBbHeight() * 0.5, this.getZ(), 1, dx, dy, dz, 0.1);
                }
                if (!(level2.random.nextFloat() < 0.65f)) continue;
                level2.sendParticles((ParticleOptions)CompanionsParticles.EMBER_POLE_EXPLOSION.get(), this.getX(), this.getY() + (double)this.getBbHeight() * 1.5, this.getZ(), 1, dx, dy, dz, 0.08);
            }
            for (LivingEntity e : this.level().getEntitiesOfClass(LivingEntity.class, new AABB(this.blockPosition()).inflate(3.0))) {
                if (Util.areEntitiesLinked((Entity)e, (Entity)this)) continue;
                this.doHurtTarget((Entity)e);
                Random random = new Random();
                if (!((double)random.nextFloat() < 0.75)) continue;
                e.setRemainingFireTicks(new Random().nextInt(3, 10) * 20);
            }
        }
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return CompanionsSounds.SMALL_FROG_DEATH.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return CompanionsSounds.SMALL_FROG_HURT.get();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return CompanionsSounds.SMALL_FROG_IDLE.get();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new EmberPoleApproachTargetGoal(this, 0.45, 0.4f, 1.25f));
        this.goalSelector.addGoal(3, (Goal)new CompanionSummonFollowOwnerGoal(this, 0.6, 6.0f, 2.0f, false));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new CompanionsSummonHurtTargetGoal(this));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.isExploding()) {
            event.setAnimation(this.EXPLODE);
        } else if (event.isMoving()) {
            event.setAnimation(this.WALK);
        } else {
            event.setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

