/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.summon;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.SummonFrogEntity;
import dev.xylonity.companions.common.entity.ai.cornelius.goal.SummonHopToTargetGoal;
import dev.xylonity.companions.common.entity.ai.cornelius.summon.goal.NetherBullfrogAirSlashGoal;
import dev.xylonity.companions.common.entity.ai.cornelius.summon.goal.NetherBullfrogSlashLeftGoal;
import dev.xylonity.companions.common.entity.ai.cornelius.summon.goal.NetherBullfrogSlashRightGoal;
import dev.xylonity.companions.common.entity.ai.cornelius.summon.goal.NetherBullfrogSpinSlashGoal;
import dev.xylonity.companions.common.entity.ai.cornelius.summon.goal.SummonHopToOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsSummonHurtTargetGoal;
import dev.xylonity.companions.common.util.interfaces.IFrogJumpUtil;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class NetherBullfrogEntity
extends SummonFrogEntity
implements IFrogJumpUtil {
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation SLASH = RawAnimation.begin().thenPlay("slash");
    private final RawAnimation SLASH2 = RawAnimation.begin().thenPlay("slash2");
    private final RawAnimation SPIN_SLASH = RawAnimation.begin().thenPlay("spin_slash");
    private final RawAnimation AIR_SLASH = RawAnimation.begin().thenPlay("air_slash");

    public NetherBullfrogEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    public static AttributeSupplier setAttributes() {
        return TamableAnimal.createMobAttributes().add(Attributes.MAX_HEALTH, 60.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.55f).add(Attributes.FOLLOW_RANGE, 35.0).build();
    }

    @Override
    public void setCanAttack(boolean canAttack) {
    }

    @Override
    public void tick() {
        super.tick();
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return CompanionsSounds.NETHER_BULLFROG_HURT.get();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return CompanionsSounds.NETHER_BULLFROG_IDLE.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return CompanionsSounds.NETHER_BULLFROG_DEATH.get();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(1, (Goal)new NetherBullfrogAirSlashGoal(this, 40, 120));
        this.goalSelector.addGoal(1, (Goal)new NetherBullfrogSpinSlashGoal(this, 40, 120));
        this.goalSelector.addGoal(1, (Goal)new NetherBullfrogSlashRightGoal(this, 40, 120));
        this.goalSelector.addGoal(1, (Goal)new NetherBullfrogSlashLeftGoal(this, 40, 120));
        this.goalSelector.addGoal(3, new SummonHopToTargetGoal<NetherBullfrogEntity>(this, 0.65f));
        this.goalSelector.addGoal(4, new SummonHopToOwnerGoal<NetherBullfrogEntity>(this, 0.725, 6.0f, 2.0f, false));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new CompanionsSummonHurtTargetGoal(this));
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    @Override
    protected SoundEvent jumpSound() {
        return CompanionsSounds.NETHER_BULLFROG_JUMP.get();
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getAttackType() == 1) {
            event.setAnimation(this.SLASH);
        } else if (this.getAttackType() == 2) {
            event.setAnimation(this.SLASH2);
        } else if (this.getAttackType() == 3) {
            event.setAnimation(this.SPIN_SLASH);
        } else if (this.getAttackType() == 4) {
            event.setAnimation(this.AIR_SLASH);
        } else if (this.getCycleCount() >= 0) {
            event.setAnimation(this.WALK);
        } else {
            event.setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

