/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.item;

import dev.xylonity.companions.common.item.TooltipItem;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class NeedleItem
extends TooltipItem {
    public NeedleItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected String tooltipName() {
        return "needle";
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (!level.isClientSide) {
            EntityHitResult eHit;
            Entity target;
            BlockHitResult hit;
            Vec3 eyePos = player.getEyePosition();
            Vec3 look = player.getLookAngle();
            Vec3 endPos = eyePos.add(look.scale(80.0));
            BlockHitResult blockHit = level.clip(new ClipContext(eyePos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
            EntityHitResult entityHit = ProjectileUtil.getEntityHitResult((Level)level, (Entity)player, (Vec3)eyePos, (Vec3)endPos, (AABB)player.getBoundingBox().expandTowards(look.scale(80.0)).inflate(1.0), e -> e != player && e.isPickable());
            Object object = hit = entityHit != null && eyePos.distanceTo(entityHit.getLocation()) < eyePos.distanceTo(blockHit.getLocation()) ? entityHit : blockHit;
            if (hit.getType() == HitResult.Type.ENTITY && !Util.areEntitiesLinked(target = (eHit = (EntityHitResult)hit).getEntity(), (Entity)player)) {
                if (!player.getAbilities().instabuild) {
                    player.getItemInHand(hand).shrink(1);
                }
                if (target instanceof LivingEntity) {
                    LivingEntity e2 = (LivingEntity)target;
                    e2.hurt(player.damageSources().magic(), (float)CompanionsConfig.NEEDLE_ITEM_DAMAGE);
                    player.hurt(player.damageSources().magic(), (float)CompanionsConfig.NEEDLE_ITEM_DAMAGE);
                }
            }
        }
        player.swing(hand, true);
        return super.use(level, player, hand);
    }
}

