/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class TooltipItem
extends Item {
    private String tooltipName = "";

    public TooltipItem(Item.Properties properties) {
        super(properties);
    }

    public TooltipItem(Item.Properties properties, String tooltipName) {
        this(properties);
        this.tooltipName = tooltipName;
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        Component name = super.getName(stack);
        if (name instanceof MutableComponent) {
            MutableComponent c = (MutableComponent)name;
            if (this.tooltipName.equals("relic_gold")) {
                c.withStyle(ChatFormatting.GOLD);
            } else if (this.tooltipName.equals("old_cloth")) {
                c.withStyle(ChatFormatting.DARK_GREEN);
            }
        }
        return name;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (!this.tooltipName().isEmpty() && !this.tooltipName().isBlank()) {
            tooltipComponents.add((Component)Component.translatable((String)("tooltip.item.companions." + this.tooltipName())).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_GRAY}));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    protected String tooltipName() {
        return this.tooltipName;
    }
}

