/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.item.book.books;

import dev.xylonity.companions.common.entity.projectile.MagicRayCircleProjectile;
import dev.xylonity.companions.common.entity.projectile.MagicRayPieceProjectile;
import dev.xylonity.companions.common.item.book.AbstractMagicBook;
import dev.xylonity.companions.common.material.ArmorMaterials;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import dev.xylonity.knightlib.api.TickScheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MagicRayBook
extends AbstractMagicBook {
    public MagicRayBook(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected String tooltipName() {
        return "magic_ray_book";
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand) {
        if (!pLevel.isClientSide) {
            Vec3 dir = pPlayer.getLookAngle();
            double traveled = 0.0;
            for (int i = 0; i < 30; ++i) {
                Vec3 piecePos = pPlayer.getEyePosition(1.0f).add(dir).add(dir.scale(traveled));
                traveled += 1.0;
                BlockPos blockPos = BlockPos.containing((Position)piecePos);
                if (!this.isPassableBlock(pLevel, blockPos)) {
                    this.spawnRayPiece(pLevel, pPlayer, piecePos, dir, i == 0);
                    break;
                }
                this.spawnRayPiece(pLevel, pPlayer, piecePos, dir, i == 0);
            }
            pPlayer.getCooldowns().addCooldown((Item)this, (int)((double)CompanionsConfig.MAGIC_RAY_COOLDOWN * (1.0 - (double)Util.hasFullSetOn(pPlayer, ArmorMaterials.MAGE) * CompanionsConfig.MAGE_SET_COOLDOWN_REDUCTION)));
        }
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    @Override
    protected void playSound(Player player) {
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), CompanionsSounds.SPELL_RELEASE_BEAM.get(), player.getSoundSource(), 1.2f, 1.0f);
    }

    private boolean isPassableBlock(Level level, BlockPos pos) {
        return level.getBlockState(pos).getCollisionShape((BlockGetter)level, pos).isEmpty();
    }

    private void spawnRayPiece(Level pLevel, Player pPlayer, Vec3 piecePos, Vec3 lookVec, boolean isFirstPiece) {
        if (isFirstPiece) {
            MagicRayCircleProjectile circle = (MagicRayCircleProjectile)CompanionsEntities.MAGIC_RAY_PIECE_CIRCLE_PROJECTILE.get().create(pLevel);
            if (circle != null) {
                circle.setPos(piecePos.x, piecePos.y, piecePos.z);
                circle.setOwner((Entity)pPlayer);
                this.rotateProjectile(circle, lookVec);
                pLevel.addFreshEntity((Entity)circle);
            }
        } else {
            MagicRayPieceProjectile ray = (MagicRayPieceProjectile)CompanionsEntities.MAGIC_RAY_PIECE_PROJECTILE.get().create(pLevel);
            if (ray != null) {
                ray.setPos(piecePos.x, piecePos.y, piecePos.z);
                this.rotateProjectile(ray, lookVec);
                ray.setOwner((Entity)pPlayer);
                if (pLevel instanceof ServerLevel) {
                    ServerLevel level = (ServerLevel)pLevel;
                    TickScheduler.scheduleServer((Level)level, () -> pLevel.addFreshEntity((Entity)ray), (int)3);
                }
            }
        }
    }

    private void rotateProjectile(MagicRayPieceProjectile projectile, Vec3 direction) {
        projectile.setPitch((float)(-Math.atan2(direction.y, Math.sqrt(direction.x * direction.x + direction.z * direction.z)) * 57.29577951308232));
        projectile.setYaw((float)(Math.atan2(direction.z, direction.x) * 57.29577951308232) - 90.0f);
    }
}

