/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.item.book.books;

import dev.xylonity.companions.common.entity.projectile.HolinessNaginataProjectile;
import dev.xylonity.companions.common.item.book.AbstractMagicBook;
import dev.xylonity.companions.common.material.ArmorMaterials;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.List;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class NaginataBook
extends AbstractMagicBook {
    public NaginataBook(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected String tooltipName() {
        return "naginata_book";
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.companions.naginata_book_2"));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (!level.isClientSide) {
            AABB bb;
            Vec3 endPos;
            Vec3 eyePos = player.getEyePosition();
            EntityHitResult entityHit = ProjectileUtil.getEntityHitResult((Level)level, (Entity)player, (Vec3)eyePos, (Vec3)(endPos = eyePos.add(player.getLookAngle().scale(80.0))), (AABB)(bb = new AABB(eyePos, endPos).inflate(2.0)), e -> !Util.areEntitiesLinked((Entity)player, e));
            if (entityHit == null) {
                BlockHitResult blockHit = level.clip(new ClipContext(eyePos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
                if (blockHit.getType() == HitResult.Type.BLOCK) {
                    this.spawnNaginatas(player, blockHit.getLocation(), level);
                }
            } else {
                this.spawnNaginatas(player, entityHit.getEntity().position(), level);
            }
            player.getCooldowns().addCooldown((Item)this, (int)((double)CompanionsConfig.NAGINATA_COOLDOWN * (1.0 - (double)Util.hasFullSetOn(player, ArmorMaterials.MAGE) * CompanionsConfig.MAGE_SET_COOLDOWN_REDUCTION)));
        }
        return super.use(level, player, hand);
    }

    @Override
    protected void playSound(Player player) {
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), CompanionsSounds.SPELL_RELEASE_SPEARS.get(), player.getSoundSource(), 1.0f, 1.0f);
    }

    private void spawnNaginatas(Player player, Vec3 targetPos, Level level) {
        if (player.isShiftKeyDown()) {
            for (int i = 0; i < 2; ++i) {
                double dx = (new Random().nextDouble() - 0.5) * 20.0;
                double dz = (new Random().nextDouble() - 0.5) * 20.0;
                double x = targetPos.x + dx;
                double z = targetPos.z + dz;
                Vec3 spawnPos = new Vec3(x, 20.0 + targetPos.y + new Random().nextDouble() * 10.0, z);
                this.spawnNaginata(player, spawnPos, targetPos, level, 3.35);
            }
        } else {
            for (int i = 0; i < 6; ++i) {
                double dx = (new Random().nextDouble() - 0.5) * 30.0;
                double dz = (new Random().nextDouble() - 0.5) * 30.0;
                double x = targetPos.x + dx;
                double z = targetPos.z + dz;
                Vec3 spawnPos = new Vec3(x, 20.0 + targetPos.y + new Random().nextDouble() * 10.0, z);
                this.spawnNaginata(player, spawnPos, targetPos, level, 1.5 + new Random().nextDouble() * 0.5);
            }
        }
    }

    private void spawnNaginata(Player player, Vec3 spawnPos, Vec3 targetPos, Level level, double speed) {
        HolinessNaginataProjectile naginata = (HolinessNaginataProjectile)CompanionsEntities.HOLINESS_NAGINATA.get().create(level);
        if (naginata != null) {
            naginata.setOwner((Entity)player);
            naginata.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
            naginata.setDeltaMovement(targetPos.subtract(spawnPos).normalize().scale(speed));
            naginata.refreshOrientation();
            naginata.setInvisible(true);
            level.addFreshEntity((Entity)naginata);
        }
    }
}

