/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.particle;

import dev.xylonity.knightlib.common.particle.AbstractRibbonTrailParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class BaseRibbonTrailParticle
extends AbstractRibbonTrailParticle {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/particle/trail.png");
    protected final float radius;
    protected final float height;
    protected final int targetId;
    protected final float startYaw;
    protected final float yawSpeed;
    protected float ribbonHeight;

    public BaseRibbonTrailParticle(ClientLevel level, double x, double y, double z, float r, float g, float b, float radius, float height, int targetId) {
        super(level, x, y, z, 0.0, 0.0, 0.0, r, g, b);
        this.radius = radius;
        this.height = height;
        this.targetId = targetId;
        this.gravity = 0.0f;
        this.lifetime = 60;
        this.startYaw = level.random.nextFloat() * 360.0f;
        this.yawSpeed = (5.0f + level.random.nextFloat() * 5.0f) * (level.random.nextBoolean() ? 1.0f : -1.0f);
        this.ribbonHeight = 0.35f;
        Vec3 p = this.orbitPos();
        this.setPos(p.x, p.y, p.z);
    }

    public BaseRibbonTrailParticle(ClientLevel level, double x, double y, double z, float r, float g, float b, float radius, float height, int targetId, float trailHeight) {
        this(level, x, y, z, r, g, b, radius, height, targetId);
        this.ribbonHeight = trailHeight;
    }

    public void tick() {
        super.tick();
        if (this.getTarget() == null && this.targetId != -1) {
            this.remove();
            return;
        }
        this.ribbonAlpha = 1.0f - (float)this.age / (float)this.lifetime;
        this.setPos(this.orbitPos().x, this.orbitPos().y, this.orbitPos().z);
    }

    private Vec3 orbitPos() {
        double alpha = Math.toRadians(this.startYaw + this.yawSpeed * (float)this.age);
        Vec3 off = new Vec3(Math.cos(alpha) * (double)this.radius, (double)this.height * Math.sin((float)this.age * 0.1f), Math.sin(alpha) * (double)this.radius);
        return this.targetPos().add(off);
    }

    protected Vec3 targetPos() {
        return this.getTarget() != null ? this.getTarget().position().add(0.0, (double)this.getTarget().getBbHeight() * 0.5, 0.0) : new Vec3(this.x, this.y, this.z);
    }

    private Entity getTarget() {
        return this.targetId == -1 ? null : this.level.getEntity(this.targetId);
    }

    protected float getRibbonHeight() {
        return this.ribbonHeight;
    }

    protected ResourceLocation getRibbonSprite() {
        return TEXTURE;
    }

    protected int totalSegments() {
        return 5;
    }
}

