/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.particle;

import dev.xylonity.companions.common.particle.BaseRibbonTrailParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class ElectricRibbonTrailParticle
extends BaseRibbonTrailParticle {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/particle/trail.png");
    private final double amp;
    private final long seed;

    public ElectricRibbonTrailParticle(ClientLevel level, double x, double y, double z, float r, float g, float b, float radius, float height, int targetId, float trailHeight, double amplitude) {
        super(level, x, y, z, r, g, b, radius, height, targetId, trailHeight);
        this.amp = amplitude;
        this.seed = level.random.nextLong();
        this.gravity = 0.0f;
        this.lifetime = 20 + level.random.nextInt(10);
    }

    @Override
    protected ResourceLocation getRibbonSprite() {
        return TEXTURE;
    }

    @Override
    protected int totalSegments() {
        return 8;
    }

    protected int segmentInterval() {
        return 2;
    }

    protected Vec3 sampleTrailPoint(int idx, float tick) {
        Vec3 base = super.sampleTrailPoint(idx, tick);
        long h = this.seed ^ (long)this.age >> 1 ^ (long)idx * 2654435769L;
        h ^= h >>> 33;
        h *= -49064778989728563L;
        h ^= h >>> 33;
        h *= -4265267296055464877L;
        h ^= h >>> 33;
        double ox = ((double)(h >> 42 & 0x3FFL) / 1023.0 - 0.5) * this.amp;
        double oy = ((double)(h >> 21 & 0x3FFL) / 1023.0 - 0.5) * this.amp;
        double oz = ((double)(h & 0x3FFL) / 1023.0 - 0.5) * this.amp;
        return base.add(ox, oy, oz);
    }
}

