/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.particle;

import dev.xylonity.knightlib.common.particle.AbstractRibbonTrailParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SidedRibbonTrailParticle
extends AbstractRibbonTrailParticle {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/particle/trail.png");
    protected final float radius;
    protected final float height;
    protected final int targetId;
    protected final float startYaw;
    protected final float yawSpeed;
    protected float ribbonHeight;
    protected int side;

    public SidedRibbonTrailParticle(ClientLevel level, double x, double y, double z, float r, float g, float b, float radius, float height, int targetId, int side) {
        super(level, x, y, z, 0.0, 0.0, 0.0, r, g, b);
        this.radius = radius;
        this.height = height;
        this.targetId = targetId;
        this.side = side;
        this.gravity = 0.0f;
        this.lifetime = 60;
        this.startYaw = level.random.nextFloat() * 360.0f;
        this.yawSpeed = (5.0f + level.random.nextFloat() * 5.0f) * (level.random.nextBoolean() ? 1.0f : -1.0f);
        this.ribbonHeight = 0.35f;
        this.setPos(this.targetPos().x, this.targetPos().y, this.targetPos().z);
    }

    public void tick() {
        super.tick();
        if (this.getTarget() == null && this.targetId != -1) {
            this.remove();
            return;
        }
        this.ribbonAlpha = 1.0f - (float)this.age / (float)this.lifetime;
        this.setPos(this.targetPos().x, this.targetPos().y, this.targetPos().z);
    }

    protected Vec3 targetPos() {
        if (this.getTarget() == null) {
            return new Vec3(this.x, this.y, this.z);
        }
        Vec3 dir = this.getTarget().getDeltaMovement().normalize();
        if (dir.lengthSqr() < 1.0E-6) {
            return new Vec3(this.x, this.y, this.z);
        }
        Vec3 perp = new Vec3(-dir.z, 0.0, dir.x).normalize().scale(1.5);
        double y = this.getTarget().getY();
        Vec3 right = new Vec3(this.getTarget().getX(), y, this.getTarget().getZ()).add(perp);
        Vec3 left = new Vec3(this.getTarget().getX(), y, this.getTarget().getZ()).subtract(perp);
        if (this.side == 0) {
            return new Vec3(left.x, left.y, left.z);
        }
        return new Vec3(right.x, right.y, right.z);
    }

    @Nullable
    private Entity getTarget() {
        return this.targetId == -1 ? null : this.level.getEntity(this.targetId);
    }

    protected float getRibbonHeight() {
        return this.ribbonHeight;
    }

    protected ResourceLocation getRibbonSprite() {
        return TEXTURE;
    }

    protected int totalSegments() {
        return 5;
    }
}

