/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.particle;

import dev.xylonity.knightlib.common.particle.AbstractRibbonTrailParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class SpiralLaserParticle
extends AbstractRibbonTrailParticle {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/particle/trail4.png");
    private static final int TRAIL_SEGS = 16;
    private final Vec3 start;
    private final Vec3 end;
    private final Vec3 dir;
    private final Vec3 perp1;
    private final Vec3 perp2;
    private final double amplitude;
    private final double frequency;

    public SpiralLaserParticle(ClientLevel level, Vec3 start, Vec3 end, double amplitude, double frequency) {
        super(level, start.x, start.y, start.z, 0.0, 0.0, 0.0, 1.0f, 1.0f, 1.0f);
        this.start = start;
        this.end = end;
        this.amplitude = amplitude;
        this.frequency = frequency;
        this.dir = end.subtract(start).normalize();
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        if (Math.abs(this.dir.dot(up)) > 0.9) {
            up = new Vec3(1.0, 0.0, 0.0);
        }
        this.perp1 = this.dir.cross(up).normalize();
        this.perp2 = this.dir.cross(this.perp1).normalize();
        this.gravity = 0.0f;
        this.lifetime = 12;
    }

    protected ResourceLocation getRibbonSprite() {
        return TEXTURE;
    }

    protected int totalSegments() {
        return Math.min(16, (this.age + 1) * 3);
    }

    public void tick() {
        super.tick();
        this.r = 0.8f;
        this.g = 0.19607843f;
        this.b = 0.21176471f - 0.2f * (float)(Math.sin((double)this.age * 0.5) * 0.5 + 0.5);
        this.ribbonAlpha = 0.7f + 0.3f * (float)Math.abs(Math.sin((double)this.age * this.frequency));
        if (this.age >= this.lifetime - 4) {
            this.ribbonAlpha *= (float)(this.lifetime - this.age) / 4.0f;
        }
    }

    protected int getLightColor(float partialTicks) {
        return 0xF000F0;
    }

    protected Vec3 sampleTrailPoint(int idx, float partialTicks) {
        float t = (float)idx / 15.0f;
        Vec3 base = this.start.lerp(this.end, (double)t);
        double angle = (double)((float)this.age + partialTicks) * this.frequency + (double)t * Math.PI * 2.0;
        return base.add(this.perp1.scale(Math.cos(angle)).add(this.perp2.scale(Math.sin(angle))).scale(this.amplitude));
    }

    protected float getRibbonHeight() {
        return 0.2f * (1.0f + 0.2f * (float)Math.sin((double)((float)this.age + 0.5f) * this.frequency));
    }
}

