/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.compat.jei.category;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xylonity.companions.common.blockentity.SoulFurnaceBlockEntity;
import dev.xylonity.companions.common.recipe.SoulFurnaceEntityRecipe;
import dev.xylonity.companions.registry.CompanionsBlocks;
import java.util.Map;
import java.util.WeakHashMap;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Vector3f;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public final class SoulFurnaceEntityRecipeCategory
implements IRecipeCategory<SoulFurnaceEntityRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"soul_furnace_entity_interaction");
    public static final RecipeType<SoulFurnaceEntityRecipe> TYPE = new RecipeType(UID, SoulFurnaceEntityRecipe.class);
    public static final ResourceLocation SHADOW = ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/gui/sprites.png");
    private final IDrawable icon;
    private SoulFurnaceBlockEntity cachedBlockEntity;
    private long lastUpdateTime = 0L;
    private static long GLOBAL_LAST_TIME = 0L;
    private static int GLOBAL_TICK = 0;
    private final Map<SoulFurnaceEntityRecipe, Entity> entityCache = new WeakHashMap<SoulFurnaceEntityRecipe, Entity>();

    public SoulFurnaceEntityRecipeCategory(IGuiHelper gui) {
        this.icon = gui.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CompanionsBlocks.SOUL_FURNACE.get()));
    }

    @NotNull
    public RecipeType<SoulFurnaceEntityRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"jei.companions.soul_furnace_entity_interaction.title");
    }

    public int getHeight() {
        return 80;
    }

    public int getWidth() {
        return 160;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SoulFurnaceEntityRecipe rec, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 5).addItemStack(rec.input);
    }

    private SoulFurnaceBlockEntity getOrCreateBlockEntity() {
        if (this.cachedBlockEntity == null) {
            this.cachedBlockEntity = new SoulFurnaceBlockEntity(BlockPos.ZERO, CompanionsBlocks.SOUL_FURNACE.get().defaultBlockState());
        }
        return this.cachedBlockEntity;
    }

    private Entity getOrCreateEntity(SoulFurnaceEntityRecipe rec) {
        Entity entity = this.entityCache.get(rec);
        if ((entity == null || entity.getType() != rec.entityType) && Minecraft.getInstance().level != null) {
            entity = rec.entityType.create((Level)Minecraft.getInstance().level);
            this.entityCache.put(rec, entity);
        }
        return entity;
    }

    private void updateAnimation() {
        long currentTime = System.currentTimeMillis();
        if (this.lastUpdateTime == 0L) {
            this.lastUpdateTime = currentTime;
        }
        if (currentTime - this.lastUpdateTime >= 50L) {
            this.lastUpdateTime = currentTime;
        }
        long nowTicks = Minecraft.getInstance().level != null ? Minecraft.getInstance().level.getGameTime() : currentTime / 50L;
        if (currentTime - GLOBAL_LAST_TIME >= 50L) {
            GLOBAL_LAST_TIME = currentTime;
            GLOBAL_TICK = (int)nowTicks;
        }
    }

    public void draw(@NotNull SoulFurnaceEntityRecipe recipe, @NotNull IRecipeSlotsView slots, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        GeoBlockRenderer renderer;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SHADOW);
        guiGraphics.blit(SHADOW, 11, 60, 0, 41, 38, 18);
        guiGraphics.blit(SHADOW, 32, 10, 56, 30, 24, 22);
        guiGraphics.blit(SHADOW, 80, 48, 142, 6, 24, 12);
        guiGraphics.blit(SHADOW, 9, 4, 120, 0, 19, 19);
        guiGraphics.blit(SHADOW, 112, 60, 216, 5, 38, 16);
        this.updateAnimation();
        SoulFurnaceBlockEntity be = this.getOrCreateBlockEntity();
        Entity maw = this.getOrCreateEntity(recipe);
        if (maw != null) {
            maw.tickCount = GLOBAL_TICK;
        }
        if ((renderer = (GeoBlockRenderer)Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer((BlockEntity)be)) == null) {
            return;
        }
        PoseStack pose = guiGraphics.pose();
        MultiBufferSource.BufferSource buffer = guiGraphics.bufferSource();
        pose.pushPose();
        pose.translate(30.0f, 68.0f, 10.0f);
        pose.scale(24.0f, 24.0f, 24.0f);
        pose.mulPose(Axis.XP.rotationDegrees(-25.0f));
        pose.mulPose(Axis.YP.rotationDegrees(145.0f));
        pose.mulPose(Axis.ZP.rotationDegrees(180.0f));
        Matrix3f normalMat = pose.last().normal();
        Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f front = new Vector3f(0.0f, 0.0f, -1.0f);
        normalMat.transform(up).normalize();
        normalMat.transform(front).normalize();
        RenderSystem.setupGui3DDiffuseLighting((Vector3f)up, (Vector3f)front);
        try {
            float partialTicks = 0.0f;
            renderer.render((BlockEntity)be, partialTicks, pose, (MultiBufferSource)buffer, LightTexture.pack((int)15, (int)15), OverlayTexture.NO_OVERLAY);
        }
        catch (Exception e) {
            renderer.render((BlockEntity)be, 0.0f, pose, (MultiBufferSource)buffer, LightTexture.pack((int)15, (int)15), OverlayTexture.NO_OVERLAY);
        }
        pose.popPose();
        EntityRenderer entityRenderer = null;
        if (maw != null) {
            entityRenderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(maw);
        }
        if (entityRenderer == null) {
            return;
        }
        pose.pushPose();
        pose.translate(132.0f, 65.0f, 20.0f);
        pose.scale(28.0f, 28.0f, 28.0f);
        pose.mulPose(Axis.XP.rotationDegrees(-25.0f));
        pose.mulPose(Axis.YP.rotationDegrees(45.0f));
        pose.mulPose(Axis.ZP.rotationDegrees(180.0f));
        Matrix3f normalMat2 = pose.last().normal();
        Vector3f up2 = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f front2 = new Vector3f(0.0f, 1.0f, 0.0f);
        normalMat2.transform(up2).normalize();
        normalMat2.transform(front2).normalize();
        RenderSystem.setupGui3DDiffuseLighting((Vector3f)up2, (Vector3f)front2);
        try {
            float partialTicks = 0.0f;
            entityRenderer.render(maw, 0.0f, partialTicks, pose, (MultiBufferSource)buffer, LightTexture.pack((int)15, (int)15));
        }
        catch (Exception e) {
            entityRenderer.render(maw, 0.0f, 0.0f, pose, (MultiBufferSource)buffer, LightTexture.pack((int)15, (int)15));
        }
        pose.popPose();
        buffer.endBatch();
    }
}

