/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.compat.jei.category;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xylonity.companions.common.blockentity.SoulFurnaceBlockEntity;
import dev.xylonity.companions.common.recipe.SoulFurnaceItemRecipe;
import dev.xylonity.companions.registry.CompanionsBlocks;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Vector3f;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public final class SoulFurnaceItemRecipeCategory
implements IRecipeCategory<SoulFurnaceItemRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"soul_furnace_item_interaction");
    public static final RecipeType<SoulFurnaceItemRecipe> TYPE = new RecipeType(UID, SoulFurnaceItemRecipe.class);
    public static final ResourceLocation SHADOW = ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/gui/sprites.png");
    private final IDrawable icon;
    private SoulFurnaceBlockEntity cachedBlockEntity;
    private long lastUpdateTime = 0L;

    public SoulFurnaceItemRecipeCategory(IGuiHelper gui) {
        this.icon = gui.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CompanionsBlocks.SOUL_FURNACE.get()));
    }

    @NotNull
    public RecipeType<SoulFurnaceItemRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"jei.companions.soul_furnace_item_interaction.title");
    }

    public int getHeight() {
        return 80;
    }

    public int getWidth() {
        return 160;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SoulFurnaceItemRecipe rec, @NotNull IFocusGroup focuses) {
        this.cachedBlockEntity = null;
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 5).addItemStack(rec.input());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 130, 42).addItemStack(rec.output());
    }

    private SoulFurnaceBlockEntity getOrCreateBlockEntity() {
        if (this.cachedBlockEntity == null) {
            this.cachedBlockEntity = new SoulFurnaceBlockEntity(BlockPos.ZERO, CompanionsBlocks.SOUL_FURNACE.get().defaultBlockState());
            this.cachedBlockEntity.isLit = true;
        }
        return this.cachedBlockEntity;
    }

    private void updateAnimation() {
        long currentTime = System.currentTimeMillis();
        if (this.lastUpdateTime == 0L) {
            this.lastUpdateTime = currentTime;
        }
        if (currentTime - this.lastUpdateTime >= 50L) {
            this.lastUpdateTime = currentTime;
        }
    }

    public void draw(@NotNull SoulFurnaceItemRecipe recipe, @NotNull IRecipeSlotsView slots, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SHADOW);
        guiGraphics.blit(SHADOW, 24, 57, 0, 41, 38, 18);
        guiGraphics.blit(SHADOW, 32, 10, 46, 3, 33, 22);
        guiGraphics.blit(SHADOW, 85, 45, 81, 6, 39, 12);
        guiGraphics.blit(SHADOW, 129, 41, 120, 0, 19, 19);
        guiGraphics.blit(SHADOW, 9, 4, 120, 0, 19, 19);
        this.updateAnimation();
        SoulFurnaceBlockEntity be = this.getOrCreateBlockEntity();
        GeoBlockRenderer renderer = (GeoBlockRenderer)Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer((BlockEntity)be);
        if (renderer == null) {
            return;
        }
        PoseStack pose = guiGraphics.pose();
        MultiBufferSource.BufferSource buffer = guiGraphics.bufferSource();
        pose.pushPose();
        pose.translate(43.0f, 65.0f, 10.0f);
        pose.scale(24.0f, 24.0f, 24.0f);
        pose.mulPose(Axis.XP.rotationDegrees(-25.0f));
        pose.mulPose(Axis.YP.rotationDegrees(145.0f));
        pose.mulPose(Axis.ZP.rotationDegrees(180.0f));
        Matrix3f normalMat = pose.last().normal();
        Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f front = new Vector3f(0.0f, 0.0f, -1.0f);
        normalMat.transform(up).normalize();
        normalMat.transform(front).normalize();
        RenderSystem.setupGui3DDiffuseLighting((Vector3f)up, (Vector3f)front);
        try {
            float partialTicks = (float)((double)(System.currentTimeMillis() - this.lastUpdateTime) / 50.0);
            renderer.render((BlockEntity)be, partialTicks, pose, (MultiBufferSource)buffer, LightTexture.pack((int)15, (int)15), OverlayTexture.NO_OVERLAY);
        }
        catch (Exception e) {
            renderer.render((BlockEntity)be, Minecraft.getInstance().getTimer().getGameTimeDeltaTicks(), pose, (MultiBufferSource)buffer, LightTexture.pack((int)15, (int)15), OverlayTexture.NO_OVERLAY);
        }
        pose.popPose();
        buffer.endBatch();
    }
}

