/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.client.model;

import com.berksire.furniture.client.entity.PellsEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class PellsModel<T extends Entity>
extends EntityModel<T> {
    private final ModelPart Head;
    private final ModelPart Body;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;
    private final ModelPart Stand;
    private final ModelPart Baseplate;

    public PellsModel(ModelPart root) {
        this.Head = root.getChild("Head");
        this.Body = root.getChild("Body");
        this.RightArm = root.getChild("RightArm");
        this.LeftArm = root.getChild("LeftArm");
        this.Stand = root.getChild("Stand");
        this.Baseplate = root.getChild("Baseplate");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Head = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 13).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(27, 24).addBox(-4.0f, -8.0f, -2.5f, 8.0f, 16.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition RightArm = partdefinition.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(32, 13).addBox(-2.0f, -2.5f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)1.5f, (float)1.0f));
        PartDefinition LeftArm = partdefinition.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(32, 13).mirror().addBox(-2.0f, -2.5f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-6.0f, (float)1.5f, (float)1.0f));
        PartDefinition Stand = partdefinition.addOrReplaceChild("Stand", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -9.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition Baseplate = partdefinition.addOrReplaceChild("Baseplate", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -0.5f, -6.0f, 12.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)23.5f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float HeadPitch) {
        if (entityIn instanceof PellsEntity) {
            PellsEntity entity = (PellsEntity)((Object)entityIn);
            float factor = (float)Math.sin((double)ageInTicks + (double)entity.getLastDamage() * 0.5);
            float speed = 0.1f;
            float bodyXRot = Mth.cos((float)(limbSwing * 0.5662f * speed + (float)Math.PI)) * 0.4f * factor * limbSwingAmount;
            float bodyZRot = Mth.sin((float)(limbSwing * 0.2262f * speed + (float)Math.PI)) * 0.1f * factor * limbSwingAmount;
            this.Body.xRot = bodyXRot;
            this.Body.zRot = bodyZRot;
            this.Head.xRot = bodyXRot;
            this.Head.zRot = bodyZRot;
            this.LeftArm.xRot = bodyXRot;
            this.LeftArm.zRot = bodyZRot;
            this.RightArm.xRot = bodyXRot;
            this.RightArm.zRot = bodyZRot;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.RightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.LeftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Stand.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Baseplate.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

