/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.client.render;

import com.berksire.furniture.client.model.ClockModel;
import com.berksire.furniture.core.block.ClockBlock;
import com.berksire.furniture.core.block.entity.ClockBlockEntity;
import com.berksire.furniture.core.util.FurnitureIdentifier;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;

public class ClockRenderer
implements BlockEntityRenderer<ClockBlockEntity> {
    private static final Map<ClockBlock.WoodType, ResourceLocation> TEXTURES = new EnumMap<ClockBlock.WoodType, ResourceLocation>(ClockBlock.WoodType.class);
    private final ClockModel<Entity> model;

    public ClockRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(ClockModel.LAYER_LOCATION);
        this.model = new ClockModel(root);
    }

    public void render(ClockBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        long gameTime = Objects.requireNonNull(blockEntity.getLevel()).getDayTime() % 24000L;
        int hours = (int)((gameTime / 1000L + 6L) % 24L);
        int minutes = (int)(gameTime % 1000L * 60L / 1000L);
        this.model.minutes.zRot = (float)((double)minutes * Math.PI / 30.0);
        this.model.hours.zRot = (float)((double)hours * Math.PI / 6.0);
        BlockState blockstate = blockEntity.getBlockState();
        poseStack.pushPose();
        poseStack.translate(0.5, 1.5, 0.5);
        poseStack.mulPose(new Quaternionf().rotateZ((float)Math.toRadians(180.0)));
        Direction direction = (Direction)blockstate.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        float rotation = direction.getOpposite().toYRot();
        poseStack.mulPose(new Quaternionf().rotateYXZ((float)Math.toRadians(rotation), 0.0f, 0.0f));
        ClockBlock block = (ClockBlock)blockEntity.getBlockState().getBlock();
        ClockBlock.WoodType woodType = block.getWoodType();
        ResourceLocation texture = TEXTURES.get((Object)woodType);
        this.renderModel(poseStack, bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)texture)), combinedLight, combinedOverlay);
        poseStack.popPose();
    }

    private void renderModel(PoseStack poseStack, VertexConsumer vertexConsumer, int light, int overlay) {
        this.model.renderToBuffer(poseStack, vertexConsumer, light, overlay);
    }

    static {
        TEXTURES.put(ClockBlock.WoodType.OAK, FurnitureIdentifier.parseIdentifier("textures/entity/oak_clock.png"));
        TEXTURES.put(ClockBlock.WoodType.SPRUCE, FurnitureIdentifier.parseIdentifier("textures/entity/spruce_clock.png"));
        TEXTURES.put(ClockBlock.WoodType.BIRCH, FurnitureIdentifier.parseIdentifier("textures/entity/birch_clock.png"));
        TEXTURES.put(ClockBlock.WoodType.JUNGLE, FurnitureIdentifier.parseIdentifier("textures/entity/jungle_clock.png"));
        TEXTURES.put(ClockBlock.WoodType.ACACIA, FurnitureIdentifier.parseIdentifier("textures/entity/acacia_clock.png"));
        TEXTURES.put(ClockBlock.WoodType.DARK_OAK, FurnitureIdentifier.parseIdentifier("textures/entity/dark_oak_clock.png"));
        TEXTURES.put(ClockBlock.WoodType.MANGROVE, FurnitureIdentifier.parseIdentifier("textures/entity/mangrove_clock.png"));
        TEXTURES.put(ClockBlock.WoodType.CHERRY, FurnitureIdentifier.parseIdentifier("textures/entity/cherry_clock.png"));
    }
}

