/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.client.render;

import com.berksire.furniture.client.entity.PellsEntity;
import com.berksire.furniture.client.model.PellsModel;
import com.berksire.furniture.core.util.FurnitureIdentifier;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class PellsRenderer
extends MobRenderer<PellsEntity, PellsModel<PellsEntity>> {
    protected static final ResourceLocation TEXTURE = FurnitureIdentifier.parseIdentifier("textures/entity/pells.png");
    private static final DecimalFormat FORMAT = new DecimalFormat("###.##", new DecimalFormatSymbols(Locale.ENGLISH));

    public PellsRenderer(EntityRendererProvider.Context context) {
        super(context, new PellsModel(PellsModel.createBodyLayer().bakeRoot()), 0.0f);
    }

    @NotNull
    public ResourceLocation getTextureLocation(PellsEntity entity) {
        return TEXTURE;
    }

    public void render(PellsEntity entityIn, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        super.render((LivingEntity)entityIn, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
        float lastDamage = entityIn.getLastDamage();
        if (lastDamage > 0.0f) {
            Color color = this.getColorByDamage(lastDamage);
            this.renderText(entityIn, FORMAT.format(lastDamage), partialTicks, stack, bufferIn, packedLightIn, color);
        }
    }

    private Color getColorByDamage(float damage) {
        if (damage >= 0.0f && damage <= 2.0f) {
            return Color.GREEN;
        }
        if (damage >= 3.0f && damage <= 6.0f) {
            return Color.WHITE;
        }
        if (damage >= 7.0f && damage <= 12.0f) {
            return Color.YELLOW;
        }
        if (damage >= 13.0f && damage <= 19.0f) {
            return Color.ORANGE;
        }
        return Color.RED;
    }

    protected void renderText(PellsEntity entityIn, String text, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, Color textColor) {
        if (entityIn.hurtTime > 0) {
            MutableComponent component = Component.literal((String)text);
            float target = (float)Math.abs(Math.sin((float)entityIn.hurtTime / 4.0f));
            entityIn.lastDamageOffsetPrev = entityIn.lastDamageOffset = Mth.lerp((float)partialTicks, (float)entityIn.lastDamageOffsetPrev, (float)target);
            float alpha = Mth.clamp((float)entityIn.lastDamageOffset, (float)0.6f, (float)1.0f);
            int argb = (int)(alpha * 255.0f) << 24 | textColor.getRGB() & 0xFFFFFF;
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.0, (double)entityIn.getBbHeight() + 0.5 + (double)entityIn.lastDamageOffset * 0.5, 0.0);
            matrixStackIn.mulPose(this.entityRenderDispatcher.cameraOrientation());
            matrixStackIn.scale(0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = matrixStackIn.last().pose();
            Font font = this.getFont();
            float x = (float)(-font.width((FormattedText)component)) / 2.0f;
            font.drawInBatch((Component)component, x, 0.0f, argb, false, matrix4f, bufferIn, Font.DisplayMode.NORMAL, 0, packedLightIn);
            matrixStackIn.popPose();
        }
    }
}

