/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.core.block;

import com.berksire.furniture.core.block.FacingBlock;
import com.berksire.furniture.core.block.entity.DisplayBlockEntity;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayBlock
extends FacingBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)DisplayBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), (VoxelShape)DisplayBlock.box((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));
    public static final MapCodec<DisplayBlock> CODEC = DisplayBlock.simpleCodec(DisplayBlock::new);

    public DisplayBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof DisplayBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        DisplayBlockEntity displayBlockEntity = (DisplayBlockEntity)blockEntity;
        ItemStack stackInHand = player.getItemInHand(interactionHand);
        if (!stackInHand.isEmpty()) {
            if (!level.isClientSide && displayBlockEntity.getDisplayedItem().isEmpty()) {
                ItemStack singleItemStack = stackInHand.copy();
                singleItemStack.setCount(1);
                if (displayBlockEntity.setDisplayedItem(singleItemStack)) {
                    if (!player.getAbilities().instabuild) {
                        stackInHand.shrink(1);
                    }
                    level.playSound(null, blockPos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return ItemInteractionResult.SUCCESS;
                }
            }
            return ItemInteractionResult.CONSUME;
        }
        if (!displayBlockEntity.getDisplayedItem().isEmpty() && !level.isClientSide) {
            ItemStack displayedItem = displayBlockEntity.getDisplayedItem().copy();
            if (!player.addItem(displayedItem)) {
                ItemEntity itemEntity = new ItemEntity(level, player.getX(), player.getY(), player.getZ(), displayedItem);
                level.addFreshEntity((Entity)itemEntity);
            }
            displayBlockEntity.removeDisplayedItem(1);
            level.playSound(null, blockPos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof DisplayBlockEntity) {
                DisplayBlockEntity displayBlockEntity = (DisplayBlockEntity)blockEntity;
                displayBlockEntity.dropContents();
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DisplayBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

