/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.core.block;

import com.berksire.furniture.core.block.DeskBlock;
import com.berksire.furniture.core.block.entity.DresserBlockEntity;
import com.berksire.furniture.core.util.FurnitureUtil;
import com.mojang.serialization.MapCodec;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DresserBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    private static final Map<FurnitureUtil.LineConnectingType, Supplier<VoxelShape>> SHAPES_SUPPLIERS = new HashMap<FurnitureUtil.LineConnectingType, Supplier<VoxelShape>>();
    private static final Map<Direction, Map<FurnitureUtil.LineConnectingType, VoxelShape>> SHAPES = new EnumMap<Direction, Map<FurnitureUtil.LineConnectingType, VoxelShape>>(Direction.class);
    public static final BooleanProperty WATERLOGGED;
    public static final DirectionProperty FACING;
    public static final EnumProperty<FurnitureUtil.LineConnectingType> TYPE;
    private final Supplier<SoundEvent> openSound;
    private final Supplier<SoundEvent> closeSound;
    public static final MapCodec<DresserBlock> CODEC;

    public DresserBlock(BlockBehaviour.Properties settings, Supplier<SoundEvent> openSound, Supplier<SoundEvent> closeSound) {
        super(settings);
        this.openSound = openSound;
        this.closeSound = closeSound;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(TYPE, (Comparable)((Object)FurnitureUtil.LineConnectingType.NONE)));
    }

    private DresserBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.openSound = null;
        this.closeSound = null;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        Direction facing = context.getHorizontalDirection().getOpposite();
        BlockState blockState = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(clickedPos).getType() == Fluids.WATER));
        return switch (facing) {
            case Direction.EAST -> (BlockState)blockState.setValue(TYPE, (Comparable)((Object)this.getType(blockState, world.getBlockState(clickedPos.south()), world.getBlockState(clickedPos.north()))));
            case Direction.SOUTH -> (BlockState)blockState.setValue(TYPE, (Comparable)((Object)this.getType(blockState, world.getBlockState(clickedPos.west()), world.getBlockState(clickedPos.east()))));
            case Direction.WEST -> (BlockState)blockState.setValue(TYPE, (Comparable)((Object)this.getType(blockState, world.getBlockState(clickedPos.north()), world.getBlockState(clickedPos.south()))));
            default -> (BlockState)blockState.setValue(TYPE, (Comparable)((Object)this.getType(blockState, world.getBlockState(clickedPos.east()), world.getBlockState(clickedPos.west()))));
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, FACING, TYPE});
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof Container) {
                Container container = (Container)blockEntity;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)container);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof DresserBlockEntity) {
            DresserBlockEntity blockEntity1 = (DresserBlockEntity)blockEntity;
            player.openMenu((MenuProvider)blockEntity1);
        }
        return InteractionResult.CONSUME;
    }

    public void playSound(Level world, BlockPos pos, boolean isOpen) {
        world.playSound(null, pos, isOpen ? this.openSound.get() : this.closeSound.get(), SoundSource.BLOCKS, 1.0f, 1.1f);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DresserBlockEntity(pos, state);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity;
        if (itemStack.has(DataComponents.CUSTOM_NAME) && (blockEntity = world.getBlockEntity(pos)) instanceof DresserBlockEntity) {
            DresserBlockEntity blockEntity1 = (DresserBlockEntity)blockEntity;
            blockEntity1.name = itemStack.getHoverName();
        }
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public FurnitureUtil.LineConnectingType getType(BlockState state, BlockState left, BlockState right) {
        boolean shape_left_same = this.isConnectable(left, state);
        boolean shape_right_same = this.isConnectable(right, state);
        if (shape_left_same && shape_right_same) {
            return FurnitureUtil.LineConnectingType.MIDDLE;
        }
        if (shape_left_same) {
            return FurnitureUtil.LineConnectingType.LEFT;
        }
        if (shape_right_same) {
            return FurnitureUtil.LineConnectingType.RIGHT;
        }
        return FurnitureUtil.LineConnectingType.NONE;
    }

    protected boolean isConnectable(BlockState state1, BlockState state2) {
        return state1.getBlock() == state2.getBlock() && state1.getValue((Property)FACING) == state2.getValue((Property)FACING) || state1.getBlock() instanceof DeskBlock && state2.getBlock() instanceof DresserBlock || state1.getBlock() instanceof DresserBlock && state2.getBlock() instanceof DeskBlock;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (world.isClientSide) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        FurnitureUtil.LineConnectingType type = switch (facing) {
            case Direction.EAST -> this.getType(state, world.getBlockState(pos.south()), world.getBlockState(pos.north()));
            case Direction.SOUTH -> this.getType(state, world.getBlockState(pos.west()), world.getBlockState(pos.east()));
            case Direction.WEST -> this.getType(state, world.getBlockState(pos.north()), world.getBlockState(pos.south()));
            default -> this.getType(state, world.getBlockState(pos.east()), world.getBlockState(pos.west()));
        };
        if (state.getValue(TYPE) != type) {
            state = (BlockState)state.setValue(TYPE, (Comparable)((Object)type));
        }
        world.setBlock(pos, state, 3);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        FurnitureUtil.LineConnectingType type = (FurnitureUtil.LineConnectingType)((Object)state.getValue(TYPE));
        return SHAPES.get(direction).get((Object)type);
    }

    private static VoxelShape makeSingleShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.25, (double)0.1875, (double)0.25), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.0, (double)0.0625, (double)0.9375, (double)0.1875, (double)0.25), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.75, (double)0.25, (double)0.1875, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.0, (double)0.75, (double)0.9375, (double)0.1875, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.8125, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.1875, (double)0.0625, (double)0.9375, (double)0.8125, (double)0.9375), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private static VoxelShape makeRightShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.8125, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.1875, (double)0.0625, (double)0.9375, (double)0.8125, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.0, (double)0.0625, (double)0.9375, (double)0.1875, (double)0.25), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.0, (double)0.75, (double)0.9375, (double)0.1875, (double)0.9375), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private static VoxelShape makeLeftShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.8125, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.1875, (double)0.0625, (double)1.0, (double)0.8125, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.75, (double)0.25, (double)0.1875, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.25, (double)0.1875, (double)0.25), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private static VoxelShape makeMiddleShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.1875, (double)0.0625, (double)1.0, (double)0.8125, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.8125, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    static {
        CODEC = DresserBlock.simpleCodec(DresserBlock::new);
        WATERLOGGED = BlockStateProperties.WATERLOGGED;
        FACING = BlockStateProperties.HORIZONTAL_FACING;
        TYPE = FurnitureUtil.LINE_CONNECTING_TYPE;
        SHAPES_SUPPLIERS.put(FurnitureUtil.LineConnectingType.NONE, DresserBlock::makeSingleShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.LineConnectingType.MIDDLE, DresserBlock::makeMiddleShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.LineConnectingType.RIGHT, DresserBlock::makeRightShape);
        SHAPES_SUPPLIERS.put(FurnitureUtil.LineConnectingType.LEFT, DresserBlock::makeLeftShape);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            SHAPES.put(direction, new HashMap());
            for (Map.Entry<FurnitureUtil.LineConnectingType, Supplier<VoxelShape>> entry : SHAPES_SUPPLIERS.entrySet()) {
                SHAPES.get(direction).put(entry.getKey(), FurnitureUtil.rotateShape(Direction.NORTH, direction, entry.getValue().get()));
            }
        }
    }
}

