/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.core.block;

import com.berksire.furniture.core.util.FurnitureUtil;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class StreetLanternWallBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final IntegerProperty BULBS = IntegerProperty.create((String)"bulbs", (int)0, (int)1);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final Map<Direction, VoxelShape> SHAPE_SINGLE = StreetLanternWallBlock.createDirectionalShapes(StreetLanternWallBlock::makeSingleShape);
    public static final Map<Direction, VoxelShape> SHAPE_DOUBLE = StreetLanternWallBlock.createDirectionalShapes(StreetLanternWallBlock::makeDoubleShape);
    public static final MapCodec<StreetLanternWallBlock> CODEC = StreetLanternWallBlock.simpleCodec(StreetLanternWallBlock::new);

    public StreetLanternWallBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)BULBS, (Comparable)Integer.valueOf(0))).setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos blockPos = pos.relative(direction.getOpposite());
        BlockState blockState = world.getBlockState(blockPos);
        return blockState.isFaceSturdy((BlockGetter)world, blockPos, direction);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED, BULBS, LIT});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        if ((Integer)state.getValue((Property)BULBS) == 0) {
            return SHAPE_SINGLE.get(direction);
        }
        return SHAPE_DOUBLE.get(direction);
    }

    private static VoxelShape makeSingleShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.5625, (double)0.4375, (double)0.6875, (double)1.0, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.5, (double)0.5, (double)0.625, (double)0.5625, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.1875, (double)0.875, (double)0.625, (double)0.4375, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.25, (double)0.625, (double)0.5625, (double)0.5625, (double)0.9375), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private static VoxelShape makeDoubleShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.5, (double)0.5, (double)0.3125, (double)0.5625, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.5625, (double)0.4375, (double)0.375, (double)1.0, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.6875, (double)0.5, (double)0.5, (double)0.9375, (double)0.5625, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.625, (double)0.5625, (double)0.4375, (double)1.0, (double)1.0, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.25, (double)0.875, (double)0.625, (double)0.5, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.2569320439671243, (double)0.3125, (double)0.59375, (double)0.7569320439671243, (double)0.5625, (double)0.90625), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private static Map<Direction, VoxelShape> createDirectionalShapes(Supplier<VoxelShape> shapeSupplier) {
        return (Map)Util.make(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                map.put(direction, FurnitureUtil.rotateShape(Direction.NORTH, direction, (VoxelShape)shapeSupplier.get()));
            }
        });
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState newState;
        BlockState blockState = context.getLevel().getBlockState(context.getClickedPos());
        if (blockState.is((Block)this)) {
            return (BlockState)blockState.setValue((Property)BULBS, (Comparable)Integer.valueOf(Math.min(1, (Integer)blockState.getValue((Property)BULBS) + 1)));
        }
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        Direction direction = context.getClickedFace();
        if (direction == Direction.DOWN || direction == Direction.UP) {
            direction = context.getHorizontalDirection().getOpposite();
        }
        if (this.canSurvive(newState = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction), (LevelReader)context.getLevel(), context.getClickedPos())) {
            return (BlockState)newState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        }
        return null;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return useContext.isSecondaryUseActive() && useContext.getItemInHand().is(this.asItem()) && (Integer)state.getValue((Property)BULBS) < 1 || super.canBeReplaced(state, useContext);
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (world.isClientSide) {
            return;
        }
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
        }
    }
}

