/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.core.block.entity;

import com.berksire.furniture.core.registry.EntityTypeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FishTankBlockEntity
extends BlockEntity
implements BlockEntityTicker<FishTankBlockEntity> {
    private boolean hasCod;
    private boolean hasPufferfish;
    private boolean hasSalmon;
    public AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;

    public FishTankBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.FISH_TANK_BLOCK_ENTITY.get(), pos, state);
    }

    public boolean hasCod() {
        return this.hasCod;
    }

    public void setHasCod(boolean hasCod) {
        this.hasCod = hasCod;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public boolean hasPufferfish() {
        return this.hasPufferfish;
    }

    public void setHasPufferfish(boolean hasPufferfish) {
        this.hasPufferfish = hasPufferfish;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public boolean hasSalmon() {
        return this.hasSalmon;
    }

    public void setHasSalmon(boolean hasSalmon) {
        this.hasSalmon = hasSalmon;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.hasCod = tag.getBoolean("HasCod");
        this.hasPufferfish = tag.getBoolean("HasPufferfish");
        this.hasSalmon = tag.getBoolean("HasSalmon");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putBoolean("HasCod", this.hasCod);
        tag.putBoolean("HasPufferfish", this.hasPufferfish);
        tag.putBoolean("HasSalmon", this.hasSalmon);
    }

    public void tick(Level level, BlockPos pos, BlockState state, FishTankBlockEntity be) {
        if (level.isClientSide) {
            this.updateAnimations();
        }
    }

    public void updateAnimations() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 123;
            this.idleAnimationState.start(0);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        return tag;
    }
}

