/*
 * Decompiled with CFR 0.152.
 */
package com.berksire.furniture.core.registry;

import com.berksire.furniture.core.block.BenchBlock;
import com.berksire.furniture.core.block.BinBlock;
import com.berksire.furniture.core.block.BlueprintsBlock;
import com.berksire.furniture.core.block.BoatInAJarBlock;
import com.berksire.furniture.core.block.CabinetBlock;
import com.berksire.furniture.core.block.CashRegisterBlock;
import com.berksire.furniture.core.block.ChimneyBlock;
import com.berksire.furniture.core.block.ClockBlock;
import com.berksire.furniture.core.block.CofferBlock;
import com.berksire.furniture.core.block.CopperChimneyBlock;
import com.berksire.furniture.core.block.CurtainBlock;
import com.berksire.furniture.core.block.DeskBlock;
import com.berksire.furniture.core.block.DeskChairBlock;
import com.berksire.furniture.core.block.DisplayBlock;
import com.berksire.furniture.core.block.DresserBlock;
import com.berksire.furniture.core.block.ExplorersBoxBlock;
import com.berksire.furniture.core.block.FishTankBlock;
import com.berksire.furniture.core.block.GramophoneBlock;
import com.berksire.furniture.core.block.GrandfatherClockBlock;
import com.berksire.furniture.core.block.LampBlock;
import com.berksire.furniture.core.block.LampWallBlock;
import com.berksire.furniture.core.block.MirrorBlock;
import com.berksire.furniture.core.block.PlanterBlock;
import com.berksire.furniture.core.block.PouffeBlock;
import com.berksire.furniture.core.block.SewingKitBlock;
import com.berksire.furniture.core.block.ShutterBlock;
import com.berksire.furniture.core.block.SofaBlock;
import com.berksire.furniture.core.block.SteamVentBlock;
import com.berksire.furniture.core.block.StreetLanternBlock;
import com.berksire.furniture.core.block.StreetLanternWallBlock;
import com.berksire.furniture.core.block.TelescopeBlock;
import com.berksire.furniture.core.block.TerrariumBlock;
import com.berksire.furniture.core.block.ToolBoxBlock;
import com.berksire.furniture.core.item.CanvasItem;
import com.berksire.furniture.core.item.PellsSpawnItem;
import com.berksire.furniture.core.item.TrashBagItem;
import com.berksire.furniture.core.registry.CanvasRegistry;
import com.berksire.furniture.core.registry.JukeboxSongRegistry;
import com.berksire.furniture.core.registry.SoundRegistry;
import com.berksire.furniture.core.registry.TagRegistry;
import com.berksire.furniture.core.util.FurnitureIdentifier;
import com.berksire.furniture.core.util.FurnitureUtil;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;

public class ObjectRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"furniture", (ResourceKey)Registries.ITEM);
    public static final Registrar<Item> ITEM_REGISTRAR = ITEMS.getRegistrar();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"furniture", (ResourceKey)Registries.BLOCK);
    public static final Registrar<Block> BLOCK_REGISTRAR = BLOCKS.getRegistrar();
    public static final Map<String, RegistrySupplier<Block>> SOFAS = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> POUFFE = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> LAMPS = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> WALL_LAMPS = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Item>> LAMP_ITEMS = new HashMap<String, RegistrySupplier<Item>>();
    public static final Map<String, RegistrySupplier<Block>> CURTAINS = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> CABINETS = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> DESK_CHAIRS = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> DESKS = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> DRESSER = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> GRANDFATHER_CLOCKS = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> CLOCKS = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> BENCHES = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> MIRRORS = new HashMap<String, RegistrySupplier<Block>>();
    public static final Map<String, RegistrySupplier<Block>> SHUTTERS = new HashMap<String, RegistrySupplier<Block>>();
    public static final RegistrySupplier<Block> GRAMOPHONE = ObjectRegistry.registerWithItem("gramophone", () -> new GramophoneBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.JUKEBOX)));
    public static final RegistrySupplier<Block> TELESCOPE = ObjectRegistry.registerWithItem("telescope", () -> new TelescopeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final RegistrySupplier<Block> COFFER = ObjectRegistry.registerWithItem("coffer", () -> new CofferBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_WOOL).pushReaction(PushReaction.DESTROY)));
    public static final RegistrySupplier<Block> EXPLORERS_BOX = ObjectRegistry.registerWithItem("explorers_box", () -> new ExplorersBoxBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CARTOGRAPHY_TABLE)));
    public static final RegistrySupplier<Block> CASH_REGISTER = ObjectRegistry.registerWithItem("cash_register", () -> new CashRegisterBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COPPER_BLOCK)));
    public static final RegistrySupplier<Block> TOOL_BOX = ObjectRegistry.registerWithItem("tool_box", () -> new ToolBoxBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SMITHING_TABLE).pushReaction(PushReaction.DESTROY)));
    public static final RegistrySupplier<Block> BLUEPRINTS = ObjectRegistry.registerWithItem("blueprints", () -> new BlueprintsBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAKE).instabreak()));
    public static final RegistrySupplier<Block> SEWING_KIT = ObjectRegistry.registerWithItem("sewing_kit", () -> new SewingKitBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LOOM)));
    public static final RegistrySupplier<Item> CANVAS = ObjectRegistry.registerItem("canvas", () -> new CanvasItem(new Item.Properties(), CanvasRegistry.LONELY_DAISY, TagRegistry.PAINTINGS));
    public static final RegistrySupplier<Block> BIN = ObjectRegistry.registerWithItem("bin", () -> new BinBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final RegistrySupplier<Item> TRASH_BAG = ObjectRegistry.registerItem("trash_bag", () -> new TrashBagItem(new Item.Properties()));
    public static final RegistrySupplier<Block> STEAM_VENT = ObjectRegistry.registerWithItem("steam_vent", () -> new SteamVentBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final RegistrySupplier<Block> COPPER_FISH_TANK = ObjectRegistry.registerWithItem("copper_fish_tank", () -> new FishTankBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COPPER_BLOCK)));
    public static final RegistrySupplier<Block> IRON_FISH_TANK = ObjectRegistry.registerWithItem("iron_fish_tank", () -> new FishTankBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final RegistrySupplier<Block> BRICK_CHIMNEY = ObjectRegistry.registerWithItem("brick_chimney", () -> new ChimneyBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final RegistrySupplier<Block> STONE_BRICKS_CHIMNEY = ObjectRegistry.registerWithItem("stone_bricks_chimney", () -> new ChimneyBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final RegistrySupplier<Block> COPPER_CHIMNEY = ObjectRegistry.registerWithItem("copper_chimney", () -> new CopperChimneyBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COPPER_BLOCK)));
    public static final RegistrySupplier<Block> BOAT_IN_A_JAR = ObjectRegistry.registerWithItem("boat_in_a_jar", () -> new BoatInAJarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS)));
    public static final RegistrySupplier<Block> STREET_LANTERN = ObjectRegistry.registerWithoutItem("street_lantern", () -> new StreetLanternBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DECORATED_POT).lightLevel(StreetLanternBlock::vanillaLightLevel)));
    public static final RegistrySupplier<Block> STREET_WALL_LANTERN = ObjectRegistry.registerWithoutItem("street_lantern_wall", () -> new StreetLanternWallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DECORATED_POT).lightLevel(StreetLanternBlock::vanillaLightLevel)));
    public static final RegistrySupplier<Item> STREET_LANTERN_ITEM = ObjectRegistry.registerItem("street_lantern_item", () -> new StandingAndWallBlockItem((Block)STREET_LANTERN.get(), (Block)STREET_WALL_LANTERN.get(), new Item.Properties(), Direction.DOWN));
    public static final RegistrySupplier<Block> PLATED_STREET_LANTERN = ObjectRegistry.registerWithoutItem("plated_street_lantern", () -> new StreetLanternBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DECORATED_POT).lightLevel(StreetLanternBlock::vanillaLightLevel)));
    public static final RegistrySupplier<Block> PLATED_STREET_WALL_LANTERN = ObjectRegistry.registerWithoutItem("plated_street_lantern_wall", () -> new StreetLanternWallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DECORATED_POT).lightLevel(StreetLanternBlock::vanillaLightLevel)));
    public static final RegistrySupplier<Item> PLATED_STREET_LANTERN_ITEM = ObjectRegistry.registerItem("plated_street_lantern_item", () -> new StandingAndWallBlockItem((Block)PLATED_STREET_LANTERN.get(), (Block)PLATED_STREET_WALL_LANTERN.get(), new Item.Properties(), Direction.DOWN));
    public static final RegistrySupplier<Item> PELLS = ObjectRegistry.registerItem("pells", () -> new PellsSpawnItem(new Item.Properties()));
    public static final RegistrySupplier<Item> CPHS_PRIDE = ObjectRegistry.registerItem("cphs_pride", () -> new Item(new Item.Properties().stacksTo(1).jukeboxPlayable(JukeboxSongRegistry.CPHS_PRIDE)));
    public static final RegistrySupplier<Item> LETSDO_THEME = ObjectRegistry.registerItem("letsdo_theme", () -> new Item(new Item.Properties().stacksTo(1).jukeboxPlayable(JukeboxSongRegistry.LETSDO_THEME)));
    public static final RegistrySupplier<Block> DISPLAY = ObjectRegistry.registerWithItem("display", () -> new DisplayBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS)));
    public static final RegistrySupplier<Block> TERRARIUM = ObjectRegistry.registerWithItem("terrarium", () -> new TerrariumBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS)));
    public static final RegistrySupplier<Block> WOODEN_PLANTER = ObjectRegistry.registerWithItem("wooden_planter", () -> new PlanterBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD)));
    public static final RegistrySupplier<Block> STONE_BRICK_PLANTER = ObjectRegistry.registerWithItem("stone_brick_planter", () -> new PlanterBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS)));
    public static final String[] colors = new String[]{"white", "light_gray", "gray", "black", "red", "orange", "yellow", "lime", "green", "cyan", "light_blue", "blue", "purple", "magenta", "pink", "brown"};
    public static final String[] woodTypes;

    private static Block getCorrespondingPlank(String woodType) {
        return switch (woodType) {
            case "spruce" -> Blocks.SPRUCE_PLANKS;
            case "birch" -> Blocks.BIRCH_PLANKS;
            case "jungle" -> Blocks.JUNGLE_PLANKS;
            case "acacia" -> Blocks.ACACIA_PLANKS;
            case "dark_oak" -> Blocks.DARK_OAK_PLANKS;
            case "mangrove" -> Blocks.MANGROVE_PLANKS;
            case "cherry" -> Blocks.CHERRY_PLANKS;
            default -> Blocks.OAK_PLANKS;
        };
    }

    private static Item.Properties getSettings(Consumer<Item.Properties> consumer) {
        Item.Properties settings = new Item.Properties();
        consumer.accept(settings);
        return settings;
    }

    static Item.Properties getSettings() {
        return ObjectRegistry.getSettings(settings -> {});
    }

    public static <T extends Block> RegistrySupplier<T> registerWithItem(String name, Supplier<T> block) {
        return FurnitureUtil.registerWithItem(BLOCKS, BLOCK_REGISTRAR, ITEMS, ITEM_REGISTRAR, FurnitureIdentifier.parseIdentifier(name), block);
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(String path, Supplier<T> block) {
        return FurnitureUtil.registerWithoutItem(BLOCKS, BLOCK_REGISTRAR, FurnitureIdentifier.parseIdentifier(path), block);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(String path, Supplier<T> itemSupplier) {
        return FurnitureUtil.registerItem(ITEMS, ITEM_REGISTRAR, FurnitureIdentifier.parseIdentifier(path), itemSupplier);
    }

    static {
        for (String woodType : woodTypes = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "mangrove", "cherry"}) {
            BENCHES.put(woodType, ObjectRegistry.registerWithItem(woodType + "_bench", () -> new BenchBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)ObjectRegistry.getCorrespondingPlank(woodType)).pushReaction(PushReaction.IGNORE))));
            CABINETS.put(woodType, ObjectRegistry.registerWithItem(woodType + "_cabinet", () -> new CabinetBlock(BlockBehaviour.Properties.of().strength(2.0f, 3.0f).sound(SoundType.WOOD), (Supplier<SoundEvent>)SoundRegistry.CABINET_OPEN, (Supplier<SoundEvent>)SoundRegistry.CABINET_CLOSE)));
            CLOCKS.put(woodType, ObjectRegistry.registerWithItem(woodType + "_clock", () -> new ClockBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)ObjectRegistry.getCorrespondingPlank(woodType)).pushReaction(PushReaction.IGNORE), ClockBlock.WoodType.valueOf(woodType.toUpperCase()))));
            GRANDFATHER_CLOCKS.put(woodType, ObjectRegistry.registerWithItem(woodType + "_grandfather_clock", () -> new GrandfatherClockBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)ObjectRegistry.getCorrespondingPlank(woodType)).pushReaction(PushReaction.IGNORE), GrandfatherClockBlock.WoodType.valueOf(woodType.toUpperCase()))));
            MIRRORS.put(woodType, ObjectRegistry.registerWithItem(woodType + "_mirror", () -> new MirrorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)ObjectRegistry.getCorrespondingPlank(woodType)).pushReaction(PushReaction.IGNORE))));
            SHUTTERS.put(woodType, ObjectRegistry.registerWithItem(woodType + "_shutter", () -> new ShutterBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)ObjectRegistry.getCorrespondingPlank(woodType)).pushReaction(PushReaction.IGNORE))));
            DESKS.put(woodType, ObjectRegistry.registerWithItem(woodType + "_desk", () -> new DeskBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)ObjectRegistry.getCorrespondingPlank(woodType)).pushReaction(PushReaction.IGNORE))));
            DRESSER.put(woodType, ObjectRegistry.registerWithItem(woodType + "_dresser", () -> new DresserBlock(BlockBehaviour.Properties.of().strength(2.0f, 3.0f).sound(SoundType.WOOD), (Supplier<SoundEvent>)SoundRegistry.CABINET_OPEN, (Supplier<SoundEvent>)SoundRegistry.CABINET_CLOSE)));
            DESK_CHAIRS.put(woodType, ObjectRegistry.registerWithItem(woodType + "_desk_chair", () -> new DeskChairBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)ObjectRegistry.getCorrespondingPlank(woodType)))));
        }
        for (String color : colors) {
            DyeColor dyeColor = DyeColor.valueOf((String)color.toUpperCase(Locale.ENGLISH));
            SOFAS.put(color, ObjectRegistry.registerWithItem("sofa_" + color, () -> new SofaBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).pushReaction(PushReaction.DESTROY), dyeColor)));
            POUFFE.put(color, ObjectRegistry.registerWithItem("pouffe_" + color, () -> new PouffeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_WOOL).pushReaction(PushReaction.NORMAL), dyeColor)));
            CURTAINS.put(color, ObjectRegistry.registerWithItem("curtain_" + color, () -> new CurtainBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_WOOL).pushReaction(PushReaction.DESTROY), dyeColor)));
            String lampName = "lamp_" + color;
            String wallLampName = "lamp_wall_" + color;
            RegistrySupplier<Block> lamp = ObjectRegistry.registerWithoutItem(lampName, () -> new LampBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).lightLevel(state -> (Boolean)state.getValue((Property)AbstractCandleBlock.LIT) != false ? 15 : 0).pushReaction(PushReaction.DESTROY), dyeColor));
            LAMPS.put(color, lamp);
            RegistrySupplier<Block> wallLamp = ObjectRegistry.registerWithoutItem(wallLampName, () -> new LampWallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).lightLevel(state -> (Boolean)state.getValue((Property)AbstractCandleBlock.LIT) != false ? 15 : 0).pushReaction(PushReaction.DESTROY), dyeColor));
            WALL_LAMPS.put(color, wallLamp);
            LAMP_ITEMS.put(color, ObjectRegistry.registerItem(lampName, () -> new StandingAndWallBlockItem((Block)lamp.get(), (Block)wallLamp.get(), new Item.Properties(), Direction.DOWN)));
        }
        BLOCKS.register();
        ITEMS.register();
    }
}

